/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.Asset;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.ClaimableBalanceResponse;
import org.stellar.sdk.responses.Page;

public class ClaimableBalancesRequestBuilder
extends RequestBuilder {
    public ClaimableBalancesRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "claimable_balances");
    }

    public ClaimableBalanceResponse claimableBalance(HttpUrl uri) throws IOException {
        TypeToken<ClaimableBalanceResponse> type = new TypeToken<ClaimableBalanceResponse>(){};
        ResponseHandler<ClaimableBalanceResponse> responseHandler = new ResponseHandler<ClaimableBalanceResponse>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = this.httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public ClaimableBalanceResponse claimableBalance(String id) throws IOException {
        this.setSegments("claimable_balances", id);
        return this.claimableBalance(this.buildUri());
    }

    public ClaimableBalancesRequestBuilder forSponsor(String sponsor) {
        this.uriBuilder.setQueryParameter("sponsor", sponsor);
        return this;
    }

    public ClaimableBalancesRequestBuilder forAsset(Asset asset) {
        this.setAssetParameter("asset", asset);
        return this;
    }

    public ClaimableBalancesRequestBuilder forClaimant(String claimant) {
        this.uriBuilder.setQueryParameter("claimant", claimant);
        return this;
    }

    public static Page<ClaimableBalanceResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<ClaimableBalanceResponse>> type = new TypeToken<Page<ClaimableBalanceResponse>>(){};
        ResponseHandler<Page<ClaimableBalanceResponse>> responseHandler = new ResponseHandler<Page<ClaimableBalanceResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public Page<ClaimableBalanceResponse> execute() throws IOException, TooManyRequestsException {
        return ClaimableBalancesRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public ClaimableBalancesRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public ClaimableBalancesRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public ClaimableBalancesRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

