/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Claimant;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;

public final class ClaimableBalanceResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="asset")
    private final String assetString;
    @SerializedName(value="amount")
    private final String amount;
    @SerializedName(value="sponsor")
    private final String sponsor;
    @SerializedName(value="last_modified_ledger")
    private final Integer lastModifiedLedger;
    @SerializedName(value="last_modified_time")
    private final String lastModifiedTime;
    @SerializedName(value="claimants")
    private final List<Claimant> claimants;
    @SerializedName(value="flags")
    private final Flags flags;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="_links")
    private final Links links;

    public Asset getAsset() {
        return Asset.create(this.assetString);
    }

    public Optional<String> getSponsor() {
        return Optional.ofNullable(this.sponsor);
    }

    @Generated
    public ClaimableBalanceResponse(String id, String assetString, String amount, String sponsor, Integer lastModifiedLedger, String lastModifiedTime, List<Claimant> claimants, Flags flags, String pagingToken, Links links) {
        this.id = id;
        this.assetString = assetString;
        this.amount = amount;
        this.sponsor = sponsor;
        this.lastModifiedLedger = lastModifiedLedger;
        this.lastModifiedTime = lastModifiedTime;
        this.claimants = claimants;
        this.flags = flags;
        this.pagingToken = pagingToken;
        this.links = links;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getAssetString() {
        return this.assetString;
    }

    @Generated
    public String getAmount() {
        return this.amount;
    }

    @Generated
    public Integer getLastModifiedLedger() {
        return this.lastModifiedLedger;
    }

    @Generated
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public List<Claimant> getClaimants() {
        return this.claimants;
    }

    @Generated
    public Flags getFlags() {
        return this.flags;
    }

    @Override
    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "ClaimableBalanceResponse(id=" + this.getId() + ", assetString=" + this.getAssetString() + ", amount=" + this.getAmount() + ", sponsor=" + this.getSponsor() + ", lastModifiedLedger=" + this.getLastModifiedLedger() + ", lastModifiedTime=" + this.getLastModifiedTime() + ", claimants=" + this.getClaimants() + ", flags=" + this.getFlags() + ", pagingToken=" + this.getPagingToken() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimableBalanceResponse)) {
            return false;
        }
        ClaimableBalanceResponse other = (ClaimableBalanceResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$lastModifiedLedger = this.getLastModifiedLedger();
        Integer other$lastModifiedLedger = other.getLastModifiedLedger();
        if (this$lastModifiedLedger == null ? other$lastModifiedLedger != null : !((Object)this$lastModifiedLedger).equals(other$lastModifiedLedger)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$assetString = this.getAssetString();
        String other$assetString = other.getAssetString();
        if (this$assetString == null ? other$assetString != null : !this$assetString.equals(other$assetString)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        Optional<String> this$sponsor = this.getSponsor();
        Optional<String> other$sponsor = other.getSponsor();
        if (this$sponsor == null ? other$sponsor != null : !((Object)this$sponsor).equals(other$sponsor)) {
            return false;
        }
        String this$lastModifiedTime = this.getLastModifiedTime();
        String other$lastModifiedTime = other.getLastModifiedTime();
        if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !this$lastModifiedTime.equals(other$lastModifiedTime)) {
            return false;
        }
        List<Claimant> this$claimants = this.getClaimants();
        List<Claimant> other$claimants = other.getClaimants();
        if (this$claimants == null ? other$claimants != null : !((Object)this$claimants).equals(other$claimants)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimableBalanceResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $lastModifiedLedger = this.getLastModifiedLedger();
        result = result * 59 + ($lastModifiedLedger == null ? 43 : ((Object)$lastModifiedLedger).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $assetString = this.getAssetString();
        result = result * 59 + ($assetString == null ? 43 : $assetString.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        Optional<String> $sponsor = this.getSponsor();
        result = result * 59 + ($sponsor == null ? 43 : ((Object)$sponsor).hashCode());
        String $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : $lastModifiedTime.hashCode());
        List<Claimant> $claimants = this.getClaimants();
        result = result * 59 + ($claimants == null ? 43 : ((Object)$claimants).hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Flags {
        @SerializedName(value="clawback_enabled")
        private final Boolean clawbackEnabled;

        @Generated
        public Flags(Boolean clawbackEnabled) {
            this.clawbackEnabled = clawbackEnabled;
        }

        @Generated
        public Boolean getClawbackEnabled() {
            return this.clawbackEnabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Flags)) {
                return false;
            }
            Flags other = (Flags)o;
            Boolean this$clawbackEnabled = this.getClawbackEnabled();
            Boolean other$clawbackEnabled = other.getClawbackEnabled();
            return !(this$clawbackEnabled == null ? other$clawbackEnabled != null : !((Object)this$clawbackEnabled).equals(other$clawbackEnabled));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $clawbackEnabled = this.getClawbackEnabled();
            result = result * 59 + ($clawbackEnabled == null ? 43 : ((Object)$clawbackEnabled).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClaimableBalanceResponse.Flags(clawbackEnabled=" + this.getClawbackEnabled() + ")";
        }
    }

    public static final class Links {
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="transactions")
        private final Link transactions;
        @SerializedName(value="operations")
        private final Link operations;

        @Generated
        public Links(Link self, Link transactions, Link operations) {
            this.self = self;
            this.transactions = transactions;
            this.operations = operations;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public Link getTransactions() {
            return this.transactions;
        }

        @Generated
        public Link getOperations() {
            return this.operations;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
                return false;
            }
            Link this$transactions = this.getTransactions();
            Link other$transactions = other.getTransactions();
            if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
                return false;
            }
            Link this$operations = this.getOperations();
            Link other$operations = other.getOperations();
            return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            Link $transactions = this.getTransactions();
            result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
            Link $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClaimableBalanceResponse.Links(self=" + this.getSelf() + ", transactions=" + this.getTransactions() + ", operations=" + this.getOperations() + ")";
        }
    }
}

