/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountEntryExtensionV2;
import org.stellar.sdk.xdr.Liabilities;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountEntryExtensionV1
implements XdrElement {
    private Liabilities liabilities;
    private AccountEntryExtensionV1Ext ext;

    public Liabilities getLiabilities() {
        return this.liabilities;
    }

    public void setLiabilities(Liabilities value) {
        this.liabilities = value;
    }

    public AccountEntryExtensionV1Ext getExt() {
        return this.ext;
    }

    public void setExt(AccountEntryExtensionV1Ext value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, AccountEntryExtensionV1 encodedAccountEntryExtensionV1) throws IOException {
        Liabilities.encode(stream, encodedAccountEntryExtensionV1.liabilities);
        AccountEntryExtensionV1Ext.encode(stream, encodedAccountEntryExtensionV1.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountEntryExtensionV1.encode(stream, this);
    }

    public static AccountEntryExtensionV1 decode(XdrDataInputStream stream) throws IOException {
        AccountEntryExtensionV1 decodedAccountEntryExtensionV1 = new AccountEntryExtensionV1();
        decodedAccountEntryExtensionV1.liabilities = Liabilities.decode(stream);
        decodedAccountEntryExtensionV1.ext = AccountEntryExtensionV1Ext.decode(stream);
        return decodedAccountEntryExtensionV1;
    }

    public int hashCode() {
        return Objects.hash(this.liabilities, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountEntryExtensionV1)) {
            return false;
        }
        AccountEntryExtensionV1 other = (AccountEntryExtensionV1)object;
        return Objects.equals(this.liabilities, other.liabilities) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AccountEntryExtensionV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountEntryExtensionV1.fromXdrByteArray(bytes);
    }

    public static AccountEntryExtensionV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountEntryExtensionV1.decode(xdrDataInputStream);
    }

    public static class AccountEntryExtensionV1Ext
    implements XdrElement {
        Integer v;
        private AccountEntryExtensionV2 v2;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public AccountEntryExtensionV2 getV2() {
            return this.v2;
        }

        public void setV2(AccountEntryExtensionV2 value) {
            this.v2 = value;
        }

        public static void encode(XdrDataOutputStream stream, AccountEntryExtensionV1Ext encodedAccountEntryExtensionV1Ext) throws IOException {
            stream.writeInt(encodedAccountEntryExtensionV1Ext.getDiscriminant());
            switch (encodedAccountEntryExtensionV1Ext.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 2: {
                    AccountEntryExtensionV2.encode(stream, encodedAccountEntryExtensionV1Ext.v2);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            AccountEntryExtensionV1Ext.encode(stream, this);
        }

        public static AccountEntryExtensionV1Ext decode(XdrDataInputStream stream) throws IOException {
            AccountEntryExtensionV1Ext decodedAccountEntryExtensionV1Ext = new AccountEntryExtensionV1Ext();
            Integer discriminant = stream.readInt();
            decodedAccountEntryExtensionV1Ext.setDiscriminant(discriminant);
            switch (decodedAccountEntryExtensionV1Ext.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 2: {
                    decodedAccountEntryExtensionV1Ext.v2 = AccountEntryExtensionV2.decode(stream);
                }
            }
            return decodedAccountEntryExtensionV1Ext;
        }

        public int hashCode() {
            return Objects.hash(this.v2, this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof AccountEntryExtensionV1Ext)) {
                return false;
            }
            AccountEntryExtensionV1Ext other = (AccountEntryExtensionV1Ext)object;
            return Objects.equals(this.v2, other.v2) && Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static AccountEntryExtensionV1Ext fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return AccountEntryExtensionV1Ext.fromXdrByteArray(bytes);
        }

        public static AccountEntryExtensionV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return AccountEntryExtensionV1Ext.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;
            private AccountEntryExtensionV2 v2;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder v2(AccountEntryExtensionV2 v2) {
                this.v2 = v2;
                return this;
            }

            public AccountEntryExtensionV1Ext build() {
                AccountEntryExtensionV1Ext val = new AccountEntryExtensionV1Ext();
                val.setDiscriminant(this.discriminant);
                val.setV2(this.v2);
                return val;
            }
        }
    }

    public static final class Builder {
        private Liabilities liabilities;
        private AccountEntryExtensionV1Ext ext;

        public Builder liabilities(Liabilities liabilities) {
            this.liabilities = liabilities;
            return this;
        }

        public Builder ext(AccountEntryExtensionV1Ext ext) {
            this.ext = ext;
            return this;
        }

        public AccountEntryExtensionV1 build() {
            AccountEntryExtensionV1 val = new AccountEntryExtensionV1();
            val.setLiabilities(this.liabilities);
            val.setExt(this.ext);
            return val;
        }
    }
}

