/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountEntryExtensionV3;
import org.stellar.sdk.xdr.SponsorshipDescriptor;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountEntryExtensionV2
implements XdrElement {
    private Uint32 numSponsored;
    private Uint32 numSponsoring;
    private SponsorshipDescriptor[] signerSponsoringIDs;
    private AccountEntryExtensionV2Ext ext;

    public Uint32 getNumSponsored() {
        return this.numSponsored;
    }

    public void setNumSponsored(Uint32 value) {
        this.numSponsored = value;
    }

    public Uint32 getNumSponsoring() {
        return this.numSponsoring;
    }

    public void setNumSponsoring(Uint32 value) {
        this.numSponsoring = value;
    }

    public SponsorshipDescriptor[] getSignerSponsoringIDs() {
        return this.signerSponsoringIDs;
    }

    public void setSignerSponsoringIDs(SponsorshipDescriptor[] value) {
        this.signerSponsoringIDs = value;
    }

    public AccountEntryExtensionV2Ext getExt() {
        return this.ext;
    }

    public void setExt(AccountEntryExtensionV2Ext value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, AccountEntryExtensionV2 encodedAccountEntryExtensionV2) throws IOException {
        Uint32.encode(stream, encodedAccountEntryExtensionV2.numSponsored);
        Uint32.encode(stream, encodedAccountEntryExtensionV2.numSponsoring);
        int signerSponsoringIDssize = encodedAccountEntryExtensionV2.getSignerSponsoringIDs().length;
        stream.writeInt(signerSponsoringIDssize);
        for (int i = 0; i < signerSponsoringIDssize; ++i) {
            SponsorshipDescriptor.encode(stream, encodedAccountEntryExtensionV2.signerSponsoringIDs[i]);
        }
        AccountEntryExtensionV2Ext.encode(stream, encodedAccountEntryExtensionV2.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountEntryExtensionV2.encode(stream, this);
    }

    public static AccountEntryExtensionV2 decode(XdrDataInputStream stream) throws IOException {
        AccountEntryExtensionV2 decodedAccountEntryExtensionV2 = new AccountEntryExtensionV2();
        decodedAccountEntryExtensionV2.numSponsored = Uint32.decode(stream);
        decodedAccountEntryExtensionV2.numSponsoring = Uint32.decode(stream);
        int signerSponsoringIDssize = stream.readInt();
        decodedAccountEntryExtensionV2.signerSponsoringIDs = new SponsorshipDescriptor[signerSponsoringIDssize];
        for (int i = 0; i < signerSponsoringIDssize; ++i) {
            decodedAccountEntryExtensionV2.signerSponsoringIDs[i] = SponsorshipDescriptor.decode(stream);
        }
        decodedAccountEntryExtensionV2.ext = AccountEntryExtensionV2Ext.decode(stream);
        return decodedAccountEntryExtensionV2;
    }

    public int hashCode() {
        return Objects.hash(this.numSponsored, this.numSponsoring, Arrays.hashCode(this.signerSponsoringIDs), this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountEntryExtensionV2)) {
            return false;
        }
        AccountEntryExtensionV2 other = (AccountEntryExtensionV2)object;
        return Objects.equals(this.numSponsored, other.numSponsored) && Objects.equals(this.numSponsoring, other.numSponsoring) && Arrays.equals(this.signerSponsoringIDs, other.signerSponsoringIDs) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AccountEntryExtensionV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountEntryExtensionV2.fromXdrByteArray(bytes);
    }

    public static AccountEntryExtensionV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountEntryExtensionV2.decode(xdrDataInputStream);
    }

    public static class AccountEntryExtensionV2Ext
    implements XdrElement {
        Integer v;
        private AccountEntryExtensionV3 v3;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public AccountEntryExtensionV3 getV3() {
            return this.v3;
        }

        public void setV3(AccountEntryExtensionV3 value) {
            this.v3 = value;
        }

        public static void encode(XdrDataOutputStream stream, AccountEntryExtensionV2Ext encodedAccountEntryExtensionV2Ext) throws IOException {
            stream.writeInt(encodedAccountEntryExtensionV2Ext.getDiscriminant());
            switch (encodedAccountEntryExtensionV2Ext.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 3: {
                    AccountEntryExtensionV3.encode(stream, encodedAccountEntryExtensionV2Ext.v3);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            AccountEntryExtensionV2Ext.encode(stream, this);
        }

        public static AccountEntryExtensionV2Ext decode(XdrDataInputStream stream) throws IOException {
            AccountEntryExtensionV2Ext decodedAccountEntryExtensionV2Ext = new AccountEntryExtensionV2Ext();
            Integer discriminant = stream.readInt();
            decodedAccountEntryExtensionV2Ext.setDiscriminant(discriminant);
            switch (decodedAccountEntryExtensionV2Ext.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 3: {
                    decodedAccountEntryExtensionV2Ext.v3 = AccountEntryExtensionV3.decode(stream);
                }
            }
            return decodedAccountEntryExtensionV2Ext;
        }

        public int hashCode() {
            return Objects.hash(this.v3, this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof AccountEntryExtensionV2Ext)) {
                return false;
            }
            AccountEntryExtensionV2Ext other = (AccountEntryExtensionV2Ext)object;
            return Objects.equals(this.v3, other.v3) && Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static AccountEntryExtensionV2Ext fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return AccountEntryExtensionV2Ext.fromXdrByteArray(bytes);
        }

        public static AccountEntryExtensionV2Ext fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return AccountEntryExtensionV2Ext.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;
            private AccountEntryExtensionV3 v3;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder v3(AccountEntryExtensionV3 v3) {
                this.v3 = v3;
                return this;
            }

            public AccountEntryExtensionV2Ext build() {
                AccountEntryExtensionV2Ext val = new AccountEntryExtensionV2Ext();
                val.setDiscriminant(this.discriminant);
                val.setV3(this.v3);
                return val;
            }
        }
    }

    public static final class Builder {
        private Uint32 numSponsored;
        private Uint32 numSponsoring;
        private SponsorshipDescriptor[] signerSponsoringIDs;
        private AccountEntryExtensionV2Ext ext;

        public Builder numSponsored(Uint32 numSponsored) {
            this.numSponsored = numSponsored;
            return this;
        }

        public Builder numSponsoring(Uint32 numSponsoring) {
            this.numSponsoring = numSponsoring;
            return this;
        }

        public Builder signerSponsoringIDs(SponsorshipDescriptor[] signerSponsoringIDs) {
            this.signerSponsoringIDs = signerSponsoringIDs;
            return this;
        }

        public Builder ext(AccountEntryExtensionV2Ext ext) {
            this.ext = ext;
            return this;
        }

        public AccountEntryExtensionV2 build() {
            AccountEntryExtensionV2 val = new AccountEntryExtensionV2();
            val.setNumSponsored(this.numSponsored);
            val.setNumSponsoring(this.numSponsoring);
            val.setSignerSponsoringIDs(this.signerSponsoringIDs);
            val.setExt(this.ext);
            return val;
        }
    }
}

