/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Auth
implements XdrElement {
    private Integer flags;

    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(Integer value) {
        this.flags = value;
    }

    public static void encode(XdrDataOutputStream stream, Auth encodedAuth) throws IOException {
        stream.writeInt(encodedAuth.flags);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Auth.encode(stream, this);
    }

    public static Auth decode(XdrDataInputStream stream) throws IOException {
        Auth decodedAuth = new Auth();
        decodedAuth.flags = stream.readInt();
        return decodedAuth;
    }

    public int hashCode() {
        return Objects.hash(this.flags);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Auth)) {
            return false;
        }
        Auth other = (Auth)object;
        return Objects.equals(this.flags, other.flags);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Auth fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Auth.fromXdrByteArray(bytes);
    }

    public static Auth fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Auth.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer flags;

        public Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public Auth build() {
            Auth val = new Auth();
            val.setFlags(this.flags);
            return val;
        }
    }
}

