/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ClaimAtomType;
import org.stellar.sdk.xdr.ClaimLiquidityAtom;
import org.stellar.sdk.xdr.ClaimOfferAtom;
import org.stellar.sdk.xdr.ClaimOfferAtomV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimAtom
implements XdrElement {
    ClaimAtomType type;
    private ClaimOfferAtomV0 v0;
    private ClaimOfferAtom orderBook;
    private ClaimLiquidityAtom liquidityPool;

    public ClaimAtomType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ClaimAtomType value) {
        this.type = value;
    }

    public ClaimOfferAtomV0 getV0() {
        return this.v0;
    }

    public void setV0(ClaimOfferAtomV0 value) {
        this.v0 = value;
    }

    public ClaimOfferAtom getOrderBook() {
        return this.orderBook;
    }

    public void setOrderBook(ClaimOfferAtom value) {
        this.orderBook = value;
    }

    public ClaimLiquidityAtom getLiquidityPool() {
        return this.liquidityPool;
    }

    public void setLiquidityPool(ClaimLiquidityAtom value) {
        this.liquidityPool = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimAtom encodedClaimAtom) throws IOException {
        stream.writeInt(encodedClaimAtom.getDiscriminant().getValue());
        switch (encodedClaimAtom.getDiscriminant()) {
            case CLAIM_ATOM_TYPE_V0: {
                ClaimOfferAtomV0.encode(stream, encodedClaimAtom.v0);
                break;
            }
            case CLAIM_ATOM_TYPE_ORDER_BOOK: {
                ClaimOfferAtom.encode(stream, encodedClaimAtom.orderBook);
                break;
            }
            case CLAIM_ATOM_TYPE_LIQUIDITY_POOL: {
                ClaimLiquidityAtom.encode(stream, encodedClaimAtom.liquidityPool);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimAtom.encode(stream, this);
    }

    public static ClaimAtom decode(XdrDataInputStream stream) throws IOException {
        ClaimAtom decodedClaimAtom = new ClaimAtom();
        ClaimAtomType discriminant = ClaimAtomType.decode(stream);
        decodedClaimAtom.setDiscriminant(discriminant);
        switch (decodedClaimAtom.getDiscriminant()) {
            case CLAIM_ATOM_TYPE_V0: {
                decodedClaimAtom.v0 = ClaimOfferAtomV0.decode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_ORDER_BOOK: {
                decodedClaimAtom.orderBook = ClaimOfferAtom.decode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_LIQUIDITY_POOL: {
                decodedClaimAtom.liquidityPool = ClaimLiquidityAtom.decode(stream);
            }
        }
        return decodedClaimAtom;
    }

    public int hashCode() {
        return Objects.hash(this.v0, this.orderBook, this.liquidityPool, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClaimAtom)) {
            return false;
        }
        ClaimAtom other = (ClaimAtom)object;
        return Objects.equals(this.v0, other.v0) && Objects.equals(this.orderBook, other.orderBook) && Objects.equals(this.liquidityPool, other.liquidityPool) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ClaimAtom fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimAtom.fromXdrByteArray(bytes);
    }

    public static ClaimAtom fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimAtom.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ClaimAtomType discriminant;
        private ClaimOfferAtomV0 v0;
        private ClaimOfferAtom orderBook;
        private ClaimLiquidityAtom liquidityPool;

        public Builder discriminant(ClaimAtomType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v0(ClaimOfferAtomV0 v0) {
            this.v0 = v0;
            return this;
        }

        public Builder orderBook(ClaimOfferAtom orderBook) {
            this.orderBook = orderBook;
            return this;
        }

        public Builder liquidityPool(ClaimLiquidityAtom liquidityPool) {
            this.liquidityPool = liquidityPool;
            return this;
        }

        public ClaimAtom build() {
            ClaimAtom val = new ClaimAtom();
            val.setDiscriminant(this.discriminant);
            val.setV0(this.v0);
            val.setOrderBook(this.orderBook);
            val.setLiquidityPool(this.liquidityPool);
            return val;
        }
    }
}

