/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractCodeEntry
implements XdrElement {
    private ExtensionPoint ext;
    private Hash hash;
    private byte[] code;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash value) {
        this.hash = value;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, ContractCodeEntry encodedContractCodeEntry) throws IOException {
        ExtensionPoint.encode(stream, encodedContractCodeEntry.ext);
        Hash.encode(stream, encodedContractCodeEntry.hash);
        int codesize = encodedContractCodeEntry.code.length;
        stream.writeInt(codesize);
        stream.write(encodedContractCodeEntry.getCode(), 0, codesize);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ContractCodeEntry.encode(stream, this);
    }

    public static ContractCodeEntry decode(XdrDataInputStream stream) throws IOException {
        ContractCodeEntry decodedContractCodeEntry = new ContractCodeEntry();
        decodedContractCodeEntry.ext = ExtensionPoint.decode(stream);
        decodedContractCodeEntry.hash = Hash.decode(stream);
        int codesize = stream.readInt();
        decodedContractCodeEntry.code = new byte[codesize];
        stream.read(decodedContractCodeEntry.code, 0, codesize);
        return decodedContractCodeEntry;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.hash, Arrays.hashCode(this.code));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContractCodeEntry)) {
            return false;
        }
        ContractCodeEntry other = (ContractCodeEntry)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.hash, other.hash) && Arrays.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ContractCodeEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractCodeEntry.fromXdrByteArray(bytes);
    }

    public static ContractCodeEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractCodeEntry.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private Hash hash;
        private byte[] code;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        public Builder code(byte[] code) {
            this.code = code;
            return this;
        }

        public ContractCodeEntry build() {
            ContractCodeEntry val = new ContractCodeEntry();
            val.setExt(this.ext);
            val.setHash(this.hash);
            val.setCode(this.code);
            return val;
        }
    }
}

