/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ContractCostType implements XdrElement
{
    WasmInsnExec(0),
    MemAlloc(1),
    MemCpy(2),
    MemCmp(3),
    DispatchHostFunction(4),
    VisitObject(5),
    ValSer(6),
    ValDeser(7),
    ComputeSha256Hash(8),
    ComputeEd25519PubKey(9),
    VerifyEd25519Sig(10),
    VmInstantiation(11),
    VmCachedInstantiation(12),
    InvokeVmFunction(13),
    ComputeKeccak256Hash(14),
    ComputeEcdsaSecp256k1Sig(15),
    RecoverEcdsaSecp256k1Key(16),
    Int256AddSub(17),
    Int256Mul(18),
    Int256Div(19),
    Int256Pow(20),
    Int256Shift(21),
    ChaCha20DrawBytes(22);

    private int mValue;

    private ContractCostType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static ContractCostType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return WasmInsnExec;
            }
            case 1: {
                return MemAlloc;
            }
            case 2: {
                return MemCpy;
            }
            case 3: {
                return MemCmp;
            }
            case 4: {
                return DispatchHostFunction;
            }
            case 5: {
                return VisitObject;
            }
            case 6: {
                return ValSer;
            }
            case 7: {
                return ValDeser;
            }
            case 8: {
                return ComputeSha256Hash;
            }
            case 9: {
                return ComputeEd25519PubKey;
            }
            case 10: {
                return VerifyEd25519Sig;
            }
            case 11: {
                return VmInstantiation;
            }
            case 12: {
                return VmCachedInstantiation;
            }
            case 13: {
                return InvokeVmFunction;
            }
            case 14: {
                return ComputeKeccak256Hash;
            }
            case 15: {
                return ComputeEcdsaSecp256k1Sig;
            }
            case 16: {
                return RecoverEcdsaSecp256k1Key;
            }
            case 17: {
                return Int256AddSub;
            }
            case 18: {
                return Int256Mul;
            }
            case 19: {
                return Int256Div;
            }
            case 20: {
                return Int256Pow;
            }
            case 21: {
                return Int256Shift;
            }
            case 22: {
                return ChaCha20DrawBytes;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, ContractCostType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ContractCostType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ContractCostType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractCostType.fromXdrByteArray(bytes);
    }

    public static ContractCostType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractCostType.decode(xdrDataInputStream);
    }
}

