/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ContractIDPreimageType;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractIDPreimage
implements XdrElement {
    ContractIDPreimageType type;
    private ContractIDPreimageFromAddress fromAddress;
    private Asset fromAsset;

    public ContractIDPreimageType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ContractIDPreimageType value) {
        this.type = value;
    }

    public ContractIDPreimageFromAddress getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(ContractIDPreimageFromAddress value) {
        this.fromAddress = value;
    }

    public Asset getFromAsset() {
        return this.fromAsset;
    }

    public void setFromAsset(Asset value) {
        this.fromAsset = value;
    }

    public static void encode(XdrDataOutputStream stream, ContractIDPreimage encodedContractIDPreimage) throws IOException {
        stream.writeInt(encodedContractIDPreimage.getDiscriminant().getValue());
        switch (encodedContractIDPreimage.getDiscriminant()) {
            case CONTRACT_ID_PREIMAGE_FROM_ADDRESS: {
                ContractIDPreimageFromAddress.encode(stream, encodedContractIDPreimage.fromAddress);
                break;
            }
            case CONTRACT_ID_PREIMAGE_FROM_ASSET: {
                Asset.encode(stream, encodedContractIDPreimage.fromAsset);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ContractIDPreimage.encode(stream, this);
    }

    public static ContractIDPreimage decode(XdrDataInputStream stream) throws IOException {
        ContractIDPreimage decodedContractIDPreimage = new ContractIDPreimage();
        ContractIDPreimageType discriminant = ContractIDPreimageType.decode(stream);
        decodedContractIDPreimage.setDiscriminant(discriminant);
        switch (decodedContractIDPreimage.getDiscriminant()) {
            case CONTRACT_ID_PREIMAGE_FROM_ADDRESS: {
                decodedContractIDPreimage.fromAddress = ContractIDPreimageFromAddress.decode(stream);
                break;
            }
            case CONTRACT_ID_PREIMAGE_FROM_ASSET: {
                decodedContractIDPreimage.fromAsset = Asset.decode(stream);
            }
        }
        return decodedContractIDPreimage;
    }

    public int hashCode() {
        return Objects.hash(this.fromAddress, this.fromAsset, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContractIDPreimage)) {
            return false;
        }
        ContractIDPreimage other = (ContractIDPreimage)object;
        return Objects.equals(this.fromAddress, other.fromAddress) && Objects.equals(this.fromAsset, other.fromAsset) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ContractIDPreimage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractIDPreimage.fromXdrByteArray(bytes);
    }

    public static ContractIDPreimage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractIDPreimage.decode(xdrDataInputStream);
    }

    public static class ContractIDPreimageFromAddress
    implements XdrElement {
        private SCAddress address;
        private Uint256 salt;

        public SCAddress getAddress() {
            return this.address;
        }

        public void setAddress(SCAddress value) {
            this.address = value;
        }

        public Uint256 getSalt() {
            return this.salt;
        }

        public void setSalt(Uint256 value) {
            this.salt = value;
        }

        public static void encode(XdrDataOutputStream stream, ContractIDPreimageFromAddress encodedContractIDPreimageFromAddress) throws IOException {
            SCAddress.encode(stream, encodedContractIDPreimageFromAddress.address);
            Uint256.encode(stream, encodedContractIDPreimageFromAddress.salt);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            ContractIDPreimageFromAddress.encode(stream, this);
        }

        public static ContractIDPreimageFromAddress decode(XdrDataInputStream stream) throws IOException {
            ContractIDPreimageFromAddress decodedContractIDPreimageFromAddress = new ContractIDPreimageFromAddress();
            decodedContractIDPreimageFromAddress.address = SCAddress.decode(stream);
            decodedContractIDPreimageFromAddress.salt = Uint256.decode(stream);
            return decodedContractIDPreimageFromAddress;
        }

        public int hashCode() {
            return Objects.hash(this.address, this.salt);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ContractIDPreimageFromAddress)) {
                return false;
            }
            ContractIDPreimageFromAddress other = (ContractIDPreimageFromAddress)object;
            return Objects.equals(this.address, other.address) && Objects.equals(this.salt, other.salt);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static ContractIDPreimageFromAddress fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ContractIDPreimageFromAddress.fromXdrByteArray(bytes);
        }

        public static ContractIDPreimageFromAddress fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ContractIDPreimageFromAddress.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private SCAddress address;
            private Uint256 salt;

            public Builder address(SCAddress address) {
                this.address = address;
                return this;
            }

            public Builder salt(Uint256 salt) {
                this.salt = salt;
                return this;
            }

            public ContractIDPreimageFromAddress build() {
                ContractIDPreimageFromAddress val = new ContractIDPreimageFromAddress();
                val.setAddress(this.address);
                val.setSalt(this.salt);
                return val;
            }
        }
    }

    public static final class Builder {
        private ContractIDPreimageType discriminant;
        private ContractIDPreimageFromAddress fromAddress;
        private Asset fromAsset;

        public Builder discriminant(ContractIDPreimageType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder fromAddress(ContractIDPreimageFromAddress fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public Builder fromAsset(Asset fromAsset) {
            this.fromAsset = fromAsset;
            return this;
        }

        public ContractIDPreimage build() {
            ContractIDPreimage val = new ContractIDPreimage();
            val.setDiscriminant(this.discriminant);
            val.setFromAddress(this.fromAddress);
            val.setFromAsset(this.fromAsset);
            return val;
        }
    }
}

