/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ExtensionPoint
implements XdrElement {
    Integer v;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public static void encode(XdrDataOutputStream stream, ExtensionPoint encodedExtensionPoint) throws IOException {
        stream.writeInt(encodedExtensionPoint.getDiscriminant());
        switch (encodedExtensionPoint.getDiscriminant()) {
            default: 
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ExtensionPoint.encode(stream, this);
    }

    public static ExtensionPoint decode(XdrDataInputStream stream) throws IOException {
        ExtensionPoint decodedExtensionPoint = new ExtensionPoint();
        Integer discriminant = stream.readInt();
        decodedExtensionPoint.setDiscriminant(discriminant);
        switch (decodedExtensionPoint.getDiscriminant()) {
            default: 
        }
        return decodedExtensionPoint;
    }

    public int hashCode() {
        return Objects.hash(this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtensionPoint)) {
            return false;
        }
        ExtensionPoint other = (ExtensionPoint)object;
        return Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ExtensionPoint fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ExtensionPoint.fromXdrByteArray(bytes);
    }

    public static ExtensionPoint fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ExtensionPoint.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer discriminant;

        public Builder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public ExtensionPoint build() {
            ExtensionPoint val = new ExtensionPoint();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

