/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TxAdvertVector;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class FloodAdvert
implements XdrElement {
    private TxAdvertVector txHashes;

    public TxAdvertVector getTxHashes() {
        return this.txHashes;
    }

    public void setTxHashes(TxAdvertVector value) {
        this.txHashes = value;
    }

    public static void encode(XdrDataOutputStream stream, FloodAdvert encodedFloodAdvert) throws IOException {
        TxAdvertVector.encode(stream, encodedFloodAdvert.txHashes);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        FloodAdvert.encode(stream, this);
    }

    public static FloodAdvert decode(XdrDataInputStream stream) throws IOException {
        FloodAdvert decodedFloodAdvert = new FloodAdvert();
        decodedFloodAdvert.txHashes = TxAdvertVector.decode(stream);
        return decodedFloodAdvert;
    }

    public int hashCode() {
        return Objects.hash(this.txHashes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FloodAdvert)) {
            return false;
        }
        FloodAdvert other = (FloodAdvert)object;
        return Objects.equals(this.txHashes, other.txHashes);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static FloodAdvert fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return FloodAdvert.fromXdrByteArray(bytes);
    }

    public static FloodAdvert fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return FloodAdvert.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private TxAdvertVector txHashes;

        public Builder txHashes(TxAdvertVector txHashes) {
            this.txHashes = txHashes;
            return this;
        }

        public FloodAdvert build() {
            FloodAdvert val = new FloodAdvert();
            val.setTxHashes(this.txHashes);
            return val;
        }
    }
}

