/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.TransactionResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InnerTransactionResult
implements XdrElement {
    private Int64 feeCharged;
    private InnerTransactionResultResult result;
    private InnerTransactionResultExt ext;

    public Int64 getFeeCharged() {
        return this.feeCharged;
    }

    public void setFeeCharged(Int64 value) {
        this.feeCharged = value;
    }

    public InnerTransactionResultResult getResult() {
        return this.result;
    }

    public void setResult(InnerTransactionResultResult value) {
        this.result = value;
    }

    public InnerTransactionResultExt getExt() {
        return this.ext;
    }

    public void setExt(InnerTransactionResultExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, InnerTransactionResult encodedInnerTransactionResult) throws IOException {
        Int64.encode(stream, encodedInnerTransactionResult.feeCharged);
        InnerTransactionResultResult.encode(stream, encodedInnerTransactionResult.result);
        InnerTransactionResultExt.encode(stream, encodedInnerTransactionResult.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        InnerTransactionResult.encode(stream, this);
    }

    public static InnerTransactionResult decode(XdrDataInputStream stream) throws IOException {
        InnerTransactionResult decodedInnerTransactionResult = new InnerTransactionResult();
        decodedInnerTransactionResult.feeCharged = Int64.decode(stream);
        decodedInnerTransactionResult.result = InnerTransactionResultResult.decode(stream);
        decodedInnerTransactionResult.ext = InnerTransactionResultExt.decode(stream);
        return decodedInnerTransactionResult;
    }

    public int hashCode() {
        return Objects.hash(this.feeCharged, this.result, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof InnerTransactionResult)) {
            return false;
        }
        InnerTransactionResult other = (InnerTransactionResult)object;
        return Objects.equals(this.feeCharged, other.feeCharged) && Objects.equals(this.result, other.result) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static InnerTransactionResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InnerTransactionResult.fromXdrByteArray(bytes);
    }

    public static InnerTransactionResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InnerTransactionResult.decode(xdrDataInputStream);
    }

    public static class InnerTransactionResultResult
    implements XdrElement {
        TransactionResultCode code;
        private OperationResult[] results;

        public TransactionResultCode getDiscriminant() {
            return this.code;
        }

        public void setDiscriminant(TransactionResultCode value) {
            this.code = value;
        }

        public OperationResult[] getResults() {
            return this.results;
        }

        public void setResults(OperationResult[] value) {
            this.results = value;
        }

        public static void encode(XdrDataOutputStream stream, InnerTransactionResultResult encodedInnerTransactionResultResult) throws IOException {
            stream.writeInt(encodedInnerTransactionResultResult.getDiscriminant().getValue());
            switch (encodedInnerTransactionResultResult.getDiscriminant()) {
                case txSUCCESS: 
                case txFAILED: {
                    int resultssize = encodedInnerTransactionResultResult.getResults().length;
                    stream.writeInt(resultssize);
                    for (int i = 0; i < resultssize; ++i) {
                        OperationResult.encode(stream, encodedInnerTransactionResultResult.results[i]);
                    }
                    break;
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            InnerTransactionResultResult.encode(stream, this);
        }

        public static InnerTransactionResultResult decode(XdrDataInputStream stream) throws IOException {
            InnerTransactionResultResult decodedInnerTransactionResultResult = new InnerTransactionResultResult();
            TransactionResultCode discriminant = TransactionResultCode.decode(stream);
            decodedInnerTransactionResultResult.setDiscriminant(discriminant);
            switch (decodedInnerTransactionResultResult.getDiscriminant()) {
                case txSUCCESS: 
                case txFAILED: {
                    int resultssize = stream.readInt();
                    decodedInnerTransactionResultResult.results = new OperationResult[resultssize];
                    for (int i = 0; i < resultssize; ++i) {
                        decodedInnerTransactionResultResult.results[i] = OperationResult.decode(stream);
                    }
                    break;
                }
            }
            return decodedInnerTransactionResultResult;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.results), this.code);
        }

        public boolean equals(Object object) {
            if (!(object instanceof InnerTransactionResultResult)) {
                return false;
            }
            InnerTransactionResultResult other = (InnerTransactionResultResult)object;
            return Arrays.equals(this.results, other.results) && Objects.equals(this.code, other.code);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static InnerTransactionResultResult fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return InnerTransactionResultResult.fromXdrByteArray(bytes);
        }

        public static InnerTransactionResultResult fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return InnerTransactionResultResult.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private TransactionResultCode discriminant;
            private OperationResult[] results;

            public Builder discriminant(TransactionResultCode discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder results(OperationResult[] results) {
                this.results = results;
                return this;
            }

            public InnerTransactionResultResult build() {
                InnerTransactionResultResult val = new InnerTransactionResultResult();
                val.setDiscriminant(this.discriminant);
                val.setResults(this.results);
                return val;
            }
        }
    }

    public static class InnerTransactionResultExt
    implements XdrElement {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, InnerTransactionResultExt encodedInnerTransactionResultExt) throws IOException {
            stream.writeInt(encodedInnerTransactionResultExt.getDiscriminant());
            switch (encodedInnerTransactionResultExt.getDiscriminant()) {
                default: 
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            InnerTransactionResultExt.encode(stream, this);
        }

        public static InnerTransactionResultExt decode(XdrDataInputStream stream) throws IOException {
            InnerTransactionResultExt decodedInnerTransactionResultExt = new InnerTransactionResultExt();
            Integer discriminant = stream.readInt();
            decodedInnerTransactionResultExt.setDiscriminant(discriminant);
            switch (decodedInnerTransactionResultExt.getDiscriminant()) {
                default: 
            }
            return decodedInnerTransactionResultExt;
        }

        public int hashCode() {
            return Objects.hash(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof InnerTransactionResultExt)) {
                return false;
            }
            InnerTransactionResultExt other = (InnerTransactionResultExt)object;
            return Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static InnerTransactionResultExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return InnerTransactionResultExt.fromXdrByteArray(bytes);
        }

        public static InnerTransactionResultExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return InnerTransactionResultExt.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public InnerTransactionResultExt build() {
                InnerTransactionResultExt val = new InnerTransactionResultExt();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static final class Builder {
        private Int64 feeCharged;
        private InnerTransactionResultResult result;
        private InnerTransactionResultExt ext;

        public Builder feeCharged(Int64 feeCharged) {
            this.feeCharged = feeCharged;
            return this;
        }

        public Builder result(InnerTransactionResultResult result) {
            this.result = result;
            return this;
        }

        public Builder ext(InnerTransactionResultExt ext) {
            this.ext = ext;
            return this;
        }

        public InnerTransactionResult build() {
            InnerTransactionResult val = new InnerTransactionResult();
            val.setFeeCharged(this.feeCharged);
            val.setResult(this.result);
            val.setExt(this.ext);
            return val;
        }
    }
}

