/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerBounds
implements XdrElement {
    private Uint32 minLedger;
    private Uint32 maxLedger;

    public Uint32 getMinLedger() {
        return this.minLedger;
    }

    public void setMinLedger(Uint32 value) {
        this.minLedger = value;
    }

    public Uint32 getMaxLedger() {
        return this.maxLedger;
    }

    public void setMaxLedger(Uint32 value) {
        this.maxLedger = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerBounds encodedLedgerBounds) throws IOException {
        Uint32.encode(stream, encodedLedgerBounds.minLedger);
        Uint32.encode(stream, encodedLedgerBounds.maxLedger);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerBounds.encode(stream, this);
    }

    public static LedgerBounds decode(XdrDataInputStream stream) throws IOException {
        LedgerBounds decodedLedgerBounds = new LedgerBounds();
        decodedLedgerBounds.minLedger = Uint32.decode(stream);
        decodedLedgerBounds.maxLedger = Uint32.decode(stream);
        return decodedLedgerBounds;
    }

    public int hashCode() {
        return Objects.hash(this.minLedger, this.maxLedger);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerBounds)) {
            return false;
        }
        LedgerBounds other = (LedgerBounds)object;
        return Objects.equals(this.minLedger, other.minLedger) && Objects.equals(this.maxLedger, other.maxLedger);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerBounds fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerBounds.fromXdrByteArray(bytes);
    }

    public static LedgerBounds fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerBounds.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Uint32 minLedger;
        private Uint32 maxLedger;

        public Builder minLedger(Uint32 minLedger) {
            this.minLedger = minLedger;
            return this;
        }

        public Builder maxLedger(Uint32 maxLedger) {
            this.maxLedger = maxLedger;
            return this;
        }

        public LedgerBounds build() {
            LedgerBounds val = new LedgerBounds();
            val.setMinLedger(this.minLedger);
            val.setMaxLedger(this.maxLedger);
            return val;
        }
    }
}

