/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerHeaderExtensionV1
implements XdrElement {
    private Uint32 flags;
    private LedgerHeaderExtensionV1Ext ext;

    public Uint32 getFlags() {
        return this.flags;
    }

    public void setFlags(Uint32 value) {
        this.flags = value;
    }

    public LedgerHeaderExtensionV1Ext getExt() {
        return this.ext;
    }

    public void setExt(LedgerHeaderExtensionV1Ext value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerHeaderExtensionV1 encodedLedgerHeaderExtensionV1) throws IOException {
        Uint32.encode(stream, encodedLedgerHeaderExtensionV1.flags);
        LedgerHeaderExtensionV1Ext.encode(stream, encodedLedgerHeaderExtensionV1.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerHeaderExtensionV1.encode(stream, this);
    }

    public static LedgerHeaderExtensionV1 decode(XdrDataInputStream stream) throws IOException {
        LedgerHeaderExtensionV1 decodedLedgerHeaderExtensionV1 = new LedgerHeaderExtensionV1();
        decodedLedgerHeaderExtensionV1.flags = Uint32.decode(stream);
        decodedLedgerHeaderExtensionV1.ext = LedgerHeaderExtensionV1Ext.decode(stream);
        return decodedLedgerHeaderExtensionV1;
    }

    public int hashCode() {
        return Objects.hash(this.flags, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerHeaderExtensionV1)) {
            return false;
        }
        LedgerHeaderExtensionV1 other = (LedgerHeaderExtensionV1)object;
        return Objects.equals(this.flags, other.flags) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerHeaderExtensionV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerHeaderExtensionV1.fromXdrByteArray(bytes);
    }

    public static LedgerHeaderExtensionV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerHeaderExtensionV1.decode(xdrDataInputStream);
    }

    public static class LedgerHeaderExtensionV1Ext
    implements XdrElement {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerHeaderExtensionV1Ext encodedLedgerHeaderExtensionV1Ext) throws IOException {
            stream.writeInt(encodedLedgerHeaderExtensionV1Ext.getDiscriminant());
            switch (encodedLedgerHeaderExtensionV1Ext.getDiscriminant()) {
                default: 
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerHeaderExtensionV1Ext.encode(stream, this);
        }

        public static LedgerHeaderExtensionV1Ext decode(XdrDataInputStream stream) throws IOException {
            LedgerHeaderExtensionV1Ext decodedLedgerHeaderExtensionV1Ext = new LedgerHeaderExtensionV1Ext();
            Integer discriminant = stream.readInt();
            decodedLedgerHeaderExtensionV1Ext.setDiscriminant(discriminant);
            switch (decodedLedgerHeaderExtensionV1Ext.getDiscriminant()) {
                default: 
            }
            return decodedLedgerHeaderExtensionV1Ext;
        }

        public int hashCode() {
            return Objects.hash(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerHeaderExtensionV1Ext)) {
                return false;
            }
            LedgerHeaderExtensionV1Ext other = (LedgerHeaderExtensionV1Ext)object;
            return Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerHeaderExtensionV1Ext fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerHeaderExtensionV1Ext.fromXdrByteArray(bytes);
        }

        public static LedgerHeaderExtensionV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerHeaderExtensionV1Ext.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public LedgerHeaderExtensionV1Ext build() {
                LedgerHeaderExtensionV1Ext val = new LedgerHeaderExtensionV1Ext();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static final class Builder {
        private Uint32 flags;
        private LedgerHeaderExtensionV1Ext ext;

        public Builder flags(Uint32 flags) {
            this.flags = flags;
            return this;
        }

        public Builder ext(LedgerHeaderExtensionV1Ext ext) {
            this.ext = ext;
            return this;
        }

        public LedgerHeaderExtensionV1 build() {
            LedgerHeaderExtensionV1 val = new LedgerHeaderExtensionV1();
            val.setFlags(this.flags);
            val.setExt(this.ext);
            return val;
        }
    }
}

