/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ConfigUpgradeSetKey;
import org.stellar.sdk.xdr.LedgerUpgradeType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerUpgrade
implements XdrElement {
    LedgerUpgradeType type;
    private Uint32 newLedgerVersion;
    private Uint32 newBaseFee;
    private Uint32 newMaxTxSetSize;
    private Uint32 newBaseReserve;
    private Uint32 newFlags;
    private ConfigUpgradeSetKey newConfig;
    private Uint32 newMaxSorobanTxSetSize;

    public LedgerUpgradeType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(LedgerUpgradeType value) {
        this.type = value;
    }

    public Uint32 getNewLedgerVersion() {
        return this.newLedgerVersion;
    }

    public void setNewLedgerVersion(Uint32 value) {
        this.newLedgerVersion = value;
    }

    public Uint32 getNewBaseFee() {
        return this.newBaseFee;
    }

    public void setNewBaseFee(Uint32 value) {
        this.newBaseFee = value;
    }

    public Uint32 getNewMaxTxSetSize() {
        return this.newMaxTxSetSize;
    }

    public void setNewMaxTxSetSize(Uint32 value) {
        this.newMaxTxSetSize = value;
    }

    public Uint32 getNewBaseReserve() {
        return this.newBaseReserve;
    }

    public void setNewBaseReserve(Uint32 value) {
        this.newBaseReserve = value;
    }

    public Uint32 getNewFlags() {
        return this.newFlags;
    }

    public void setNewFlags(Uint32 value) {
        this.newFlags = value;
    }

    public ConfigUpgradeSetKey getNewConfig() {
        return this.newConfig;
    }

    public void setNewConfig(ConfigUpgradeSetKey value) {
        this.newConfig = value;
    }

    public Uint32 getNewMaxSorobanTxSetSize() {
        return this.newMaxSorobanTxSetSize;
    }

    public void setNewMaxSorobanTxSetSize(Uint32 value) {
        this.newMaxSorobanTxSetSize = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerUpgrade encodedLedgerUpgrade) throws IOException {
        stream.writeInt(encodedLedgerUpgrade.getDiscriminant().getValue());
        switch (encodedLedgerUpgrade.getDiscriminant()) {
            case LEDGER_UPGRADE_VERSION: {
                Uint32.encode(stream, encodedLedgerUpgrade.newLedgerVersion);
                break;
            }
            case LEDGER_UPGRADE_BASE_FEE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newBaseFee);
                break;
            }
            case LEDGER_UPGRADE_MAX_TX_SET_SIZE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newMaxTxSetSize);
                break;
            }
            case LEDGER_UPGRADE_BASE_RESERVE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newBaseReserve);
                break;
            }
            case LEDGER_UPGRADE_FLAGS: {
                Uint32.encode(stream, encodedLedgerUpgrade.newFlags);
                break;
            }
            case LEDGER_UPGRADE_CONFIG: {
                ConfigUpgradeSetKey.encode(stream, encodedLedgerUpgrade.newConfig);
                break;
            }
            case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE: {
                Uint32.encode(stream, encodedLedgerUpgrade.newMaxSorobanTxSetSize);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerUpgrade.encode(stream, this);
    }

    public static LedgerUpgrade decode(XdrDataInputStream stream) throws IOException {
        LedgerUpgrade decodedLedgerUpgrade = new LedgerUpgrade();
        LedgerUpgradeType discriminant = LedgerUpgradeType.decode(stream);
        decodedLedgerUpgrade.setDiscriminant(discriminant);
        switch (decodedLedgerUpgrade.getDiscriminant()) {
            case LEDGER_UPGRADE_VERSION: {
                decodedLedgerUpgrade.newLedgerVersion = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_FEE: {
                decodedLedgerUpgrade.newBaseFee = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_TX_SET_SIZE: {
                decodedLedgerUpgrade.newMaxTxSetSize = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_BASE_RESERVE: {
                decodedLedgerUpgrade.newBaseReserve = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_FLAGS: {
                decodedLedgerUpgrade.newFlags = Uint32.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_CONFIG: {
                decodedLedgerUpgrade.newConfig = ConfigUpgradeSetKey.decode(stream);
                break;
            }
            case LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE: {
                decodedLedgerUpgrade.newMaxSorobanTxSetSize = Uint32.decode(stream);
            }
        }
        return decodedLedgerUpgrade;
    }

    public int hashCode() {
        return Objects.hash(this.newLedgerVersion, this.newBaseFee, this.newMaxTxSetSize, this.newBaseReserve, this.newFlags, this.newConfig, this.newMaxSorobanTxSetSize, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerUpgrade)) {
            return false;
        }
        LedgerUpgrade other = (LedgerUpgrade)object;
        return Objects.equals(this.newLedgerVersion, other.newLedgerVersion) && Objects.equals(this.newBaseFee, other.newBaseFee) && Objects.equals(this.newMaxTxSetSize, other.newMaxTxSetSize) && Objects.equals(this.newBaseReserve, other.newBaseReserve) && Objects.equals(this.newFlags, other.newFlags) && Objects.equals(this.newConfig, other.newConfig) && Objects.equals(this.newMaxSorobanTxSetSize, other.newMaxSorobanTxSetSize) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerUpgrade fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerUpgrade.fromXdrByteArray(bytes);
    }

    public static LedgerUpgrade fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerUpgrade.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LedgerUpgradeType discriminant;
        private Uint32 newLedgerVersion;
        private Uint32 newBaseFee;
        private Uint32 newMaxTxSetSize;
        private Uint32 newBaseReserve;
        private Uint32 newFlags;
        private ConfigUpgradeSetKey newConfig;
        private Uint32 newMaxSorobanTxSetSize;

        public Builder discriminant(LedgerUpgradeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder newLedgerVersion(Uint32 newLedgerVersion) {
            this.newLedgerVersion = newLedgerVersion;
            return this;
        }

        public Builder newBaseFee(Uint32 newBaseFee) {
            this.newBaseFee = newBaseFee;
            return this;
        }

        public Builder newMaxTxSetSize(Uint32 newMaxTxSetSize) {
            this.newMaxTxSetSize = newMaxTxSetSize;
            return this;
        }

        public Builder newBaseReserve(Uint32 newBaseReserve) {
            this.newBaseReserve = newBaseReserve;
            return this;
        }

        public Builder newFlags(Uint32 newFlags) {
            this.newFlags = newFlags;
            return this;
        }

        public Builder newConfig(ConfigUpgradeSetKey newConfig) {
            this.newConfig = newConfig;
            return this;
        }

        public Builder newMaxSorobanTxSetSize(Uint32 newMaxSorobanTxSetSize) {
            this.newMaxSorobanTxSetSize = newMaxSorobanTxSetSize;
            return this;
        }

        public LedgerUpgrade build() {
            LedgerUpgrade val = new LedgerUpgrade();
            val.setDiscriminant(this.discriminant);
            val.setNewLedgerVersion(this.newLedgerVersion);
            val.setNewBaseFee(this.newBaseFee);
            val.setNewMaxTxSetSize(this.newMaxTxSetSize);
            val.setNewBaseReserve(this.newBaseReserve);
            val.setNewFlags(this.newFlags);
            val.setNewConfig(this.newConfig);
            val.setNewMaxSorobanTxSetSize(this.newMaxSorobanTxSetSize);
            return val;
        }
    }
}

