/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerUpgradeType implements XdrElement
{
    LEDGER_UPGRADE_VERSION(1),
    LEDGER_UPGRADE_BASE_FEE(2),
    LEDGER_UPGRADE_MAX_TX_SET_SIZE(3),
    LEDGER_UPGRADE_BASE_RESERVE(4),
    LEDGER_UPGRADE_FLAGS(5),
    LEDGER_UPGRADE_CONFIG(6),
    LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE(7);

    private int mValue;

    private LedgerUpgradeType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LedgerUpgradeType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return LEDGER_UPGRADE_VERSION;
            }
            case 2: {
                return LEDGER_UPGRADE_BASE_FEE;
            }
            case 3: {
                return LEDGER_UPGRADE_MAX_TX_SET_SIZE;
            }
            case 4: {
                return LEDGER_UPGRADE_BASE_RESERVE;
            }
            case 5: {
                return LEDGER_UPGRADE_FLAGS;
            }
            case 6: {
                return LEDGER_UPGRADE_CONFIG;
            }
            case 7: {
                return LEDGER_UPGRADE_MAX_SOROBAN_TX_SET_SIZE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LedgerUpgradeType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerUpgradeType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerUpgradeType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerUpgradeType.fromXdrByteArray(bytes);
    }

    public static LedgerUpgradeType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerUpgradeType.decode(xdrDataInputStream);
    }
}

