/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LiquidityPoolConstantProductParameters
implements XdrElement {
    private Asset assetA;
    private Asset assetB;
    private Int32 fee;

    public Asset getAssetA() {
        return this.assetA;
    }

    public void setAssetA(Asset value) {
        this.assetA = value;
    }

    public Asset getAssetB() {
        return this.assetB;
    }

    public void setAssetB(Asset value) {
        this.assetB = value;
    }

    public Int32 getFee() {
        return this.fee;
    }

    public void setFee(Int32 value) {
        this.fee = value;
    }

    public static void encode(XdrDataOutputStream stream, LiquidityPoolConstantProductParameters encodedLiquidityPoolConstantProductParameters) throws IOException {
        Asset.encode(stream, encodedLiquidityPoolConstantProductParameters.assetA);
        Asset.encode(stream, encodedLiquidityPoolConstantProductParameters.assetB);
        Int32.encode(stream, encodedLiquidityPoolConstantProductParameters.fee);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LiquidityPoolConstantProductParameters.encode(stream, this);
    }

    public static LiquidityPoolConstantProductParameters decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolConstantProductParameters decodedLiquidityPoolConstantProductParameters = new LiquidityPoolConstantProductParameters();
        decodedLiquidityPoolConstantProductParameters.assetA = Asset.decode(stream);
        decodedLiquidityPoolConstantProductParameters.assetB = Asset.decode(stream);
        decodedLiquidityPoolConstantProductParameters.fee = Int32.decode(stream);
        return decodedLiquidityPoolConstantProductParameters;
    }

    public int hashCode() {
        return Objects.hash(this.assetA, this.assetB, this.fee);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolConstantProductParameters)) {
            return false;
        }
        LiquidityPoolConstantProductParameters other = (LiquidityPoolConstantProductParameters)object;
        return Objects.equals(this.assetA, other.assetA) && Objects.equals(this.assetB, other.assetB) && Objects.equals(this.fee, other.fee);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LiquidityPoolConstantProductParameters fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolConstantProductParameters.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolConstantProductParameters fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolConstantProductParameters.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Asset assetA;
        private Asset assetB;
        private Int32 fee;

        public Builder assetA(Asset assetA) {
            this.assetA = assetA;
            return this;
        }

        public Builder assetB(Asset assetB) {
            this.assetB = assetB;
            return this;
        }

        public Builder fee(Int32 fee) {
            this.fee = fee;
            return this;
        }

        public LiquidityPoolConstantProductParameters build() {
            LiquidityPoolConstantProductParameters val = new LiquidityPoolConstantProductParameters();
            val.setAssetA(this.assetA);
            val.setAssetB(this.assetB);
            val.setFee(this.fee);
            return val;
        }
    }
}

