/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LiquidityPoolWithdrawOp
implements XdrElement {
    private PoolID liquidityPoolID;
    private Int64 amount;
    private Int64 minAmountA;
    private Int64 minAmountB;

    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    public void setLiquidityPoolID(PoolID value) {
        this.liquidityPoolID = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public Int64 getMinAmountA() {
        return this.minAmountA;
    }

    public void setMinAmountA(Int64 value) {
        this.minAmountA = value;
    }

    public Int64 getMinAmountB() {
        return this.minAmountB;
    }

    public void setMinAmountB(Int64 value) {
        this.minAmountB = value;
    }

    public static void encode(XdrDataOutputStream stream, LiquidityPoolWithdrawOp encodedLiquidityPoolWithdrawOp) throws IOException {
        PoolID.encode(stream, encodedLiquidityPoolWithdrawOp.liquidityPoolID);
        Int64.encode(stream, encodedLiquidityPoolWithdrawOp.amount);
        Int64.encode(stream, encodedLiquidityPoolWithdrawOp.minAmountA);
        Int64.encode(stream, encodedLiquidityPoolWithdrawOp.minAmountB);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LiquidityPoolWithdrawOp.encode(stream, this);
    }

    public static LiquidityPoolWithdrawOp decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolWithdrawOp decodedLiquidityPoolWithdrawOp = new LiquidityPoolWithdrawOp();
        decodedLiquidityPoolWithdrawOp.liquidityPoolID = PoolID.decode(stream);
        decodedLiquidityPoolWithdrawOp.amount = Int64.decode(stream);
        decodedLiquidityPoolWithdrawOp.minAmountA = Int64.decode(stream);
        decodedLiquidityPoolWithdrawOp.minAmountB = Int64.decode(stream);
        return decodedLiquidityPoolWithdrawOp;
    }

    public int hashCode() {
        return Objects.hash(this.liquidityPoolID, this.amount, this.minAmountA, this.minAmountB);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolWithdrawOp)) {
            return false;
        }
        LiquidityPoolWithdrawOp other = (LiquidityPoolWithdrawOp)object;
        return Objects.equals(this.liquidityPoolID, other.liquidityPoolID) && Objects.equals(this.amount, other.amount) && Objects.equals(this.minAmountA, other.minAmountA) && Objects.equals(this.minAmountB, other.minAmountB);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LiquidityPoolWithdrawOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolWithdrawOp.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolWithdrawOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolWithdrawOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private PoolID liquidityPoolID;
        private Int64 amount;
        private Int64 minAmountA;
        private Int64 minAmountB;

        public Builder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public Builder minAmountA(Int64 minAmountA) {
            this.minAmountA = minAmountA;
            return this;
        }

        public Builder minAmountB(Int64 minAmountB) {
            this.minAmountB = minAmountB;
            return this;
        }

        public LiquidityPoolWithdrawOp build() {
            LiquidityPoolWithdrawOp val = new LiquidityPoolWithdrawOp();
            val.setLiquidityPoolID(this.liquidityPoolID);
            val.setAmount(this.amount);
            val.setMinAmountA(this.minAmountA);
            val.setMinAmountB(this.minAmountB);
            return val;
        }
    }
}

