/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCPEnvelope;
import org.stellar.sdk.xdr.SCPQuorumSet;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PersistedSCPStateV1
implements XdrElement {
    private SCPEnvelope[] scpEnvelopes;
    private SCPQuorumSet[] quorumSets;

    public SCPEnvelope[] getScpEnvelopes() {
        return this.scpEnvelopes;
    }

    public void setScpEnvelopes(SCPEnvelope[] value) {
        this.scpEnvelopes = value;
    }

    public SCPQuorumSet[] getQuorumSets() {
        return this.quorumSets;
    }

    public void setQuorumSets(SCPQuorumSet[] value) {
        this.quorumSets = value;
    }

    public static void encode(XdrDataOutputStream stream, PersistedSCPStateV1 encodedPersistedSCPStateV1) throws IOException {
        int scpEnvelopessize = encodedPersistedSCPStateV1.getScpEnvelopes().length;
        stream.writeInt(scpEnvelopessize);
        for (int i = 0; i < scpEnvelopessize; ++i) {
            SCPEnvelope.encode(stream, encodedPersistedSCPStateV1.scpEnvelopes[i]);
        }
        int quorumSetssize = encodedPersistedSCPStateV1.getQuorumSets().length;
        stream.writeInt(quorumSetssize);
        for (int i = 0; i < quorumSetssize; ++i) {
            SCPQuorumSet.encode(stream, encodedPersistedSCPStateV1.quorumSets[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PersistedSCPStateV1.encode(stream, this);
    }

    public static PersistedSCPStateV1 decode(XdrDataInputStream stream) throws IOException {
        PersistedSCPStateV1 decodedPersistedSCPStateV1 = new PersistedSCPStateV1();
        int scpEnvelopessize = stream.readInt();
        decodedPersistedSCPStateV1.scpEnvelopes = new SCPEnvelope[scpEnvelopessize];
        for (int i = 0; i < scpEnvelopessize; ++i) {
            decodedPersistedSCPStateV1.scpEnvelopes[i] = SCPEnvelope.decode(stream);
        }
        int quorumSetssize = stream.readInt();
        decodedPersistedSCPStateV1.quorumSets = new SCPQuorumSet[quorumSetssize];
        for (int i = 0; i < quorumSetssize; ++i) {
            decodedPersistedSCPStateV1.quorumSets[i] = SCPQuorumSet.decode(stream);
        }
        return decodedPersistedSCPStateV1;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.scpEnvelopes), Arrays.hashCode(this.quorumSets));
    }

    public boolean equals(Object object) {
        if (!(object instanceof PersistedSCPStateV1)) {
            return false;
        }
        PersistedSCPStateV1 other = (PersistedSCPStateV1)object;
        return Arrays.equals(this.scpEnvelopes, other.scpEnvelopes) && Arrays.equals(this.quorumSets, other.quorumSets);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PersistedSCPStateV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PersistedSCPStateV1.fromXdrByteArray(bytes);
    }

    public static PersistedSCPStateV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PersistedSCPStateV1.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCPEnvelope[] scpEnvelopes;
        private SCPQuorumSet[] quorumSets;

        public Builder scpEnvelopes(SCPEnvelope[] scpEnvelopes) {
            this.scpEnvelopes = scpEnvelopes;
            return this;
        }

        public Builder quorumSets(SCPQuorumSet[] quorumSets) {
            this.quorumSets = quorumSets;
            return this;
        }

        public PersistedSCPStateV1 build() {
            PersistedSCPStateV1 val = new PersistedSCPStateV1();
            val.setScpEnvelopes(this.scpEnvelopes);
            val.setQuorumSets(this.quorumSets);
            return val;
        }
    }
}

