/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SCPBallot;
import org.stellar.sdk.xdr.SCPNomination;
import org.stellar.sdk.xdr.SCPStatementType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPStatement
implements XdrElement {
    private NodeID nodeID;
    private Uint64 slotIndex;
    private SCPStatementPledges pledges;

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(NodeID value) {
        this.nodeID = value;
    }

    public Uint64 getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(Uint64 value) {
        this.slotIndex = value;
    }

    public SCPStatementPledges getPledges() {
        return this.pledges;
    }

    public void setPledges(SCPStatementPledges value) {
        this.pledges = value;
    }

    public static void encode(XdrDataOutputStream stream, SCPStatement encodedSCPStatement) throws IOException {
        NodeID.encode(stream, encodedSCPStatement.nodeID);
        Uint64.encode(stream, encodedSCPStatement.slotIndex);
        SCPStatementPledges.encode(stream, encodedSCPStatement.pledges);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCPStatement.encode(stream, this);
    }

    public static SCPStatement decode(XdrDataInputStream stream) throws IOException {
        SCPStatement decodedSCPStatement = new SCPStatement();
        decodedSCPStatement.nodeID = NodeID.decode(stream);
        decodedSCPStatement.slotIndex = Uint64.decode(stream);
        decodedSCPStatement.pledges = SCPStatementPledges.decode(stream);
        return decodedSCPStatement;
    }

    public int hashCode() {
        return Objects.hash(this.nodeID, this.slotIndex, this.pledges);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCPStatement)) {
            return false;
        }
        SCPStatement other = (SCPStatement)object;
        return Objects.equals(this.nodeID, other.nodeID) && Objects.equals(this.slotIndex, other.slotIndex) && Objects.equals(this.pledges, other.pledges);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCPStatement fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPStatement.fromXdrByteArray(bytes);
    }

    public static SCPStatement fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPStatement.decode(xdrDataInputStream);
    }

    public static class SCPStatementPledges
    implements XdrElement {
        SCPStatementType type;
        private SCPStatementPrepare prepare;
        private SCPStatementConfirm confirm;
        private SCPStatementExternalize externalize;
        private SCPNomination nominate;

        public SCPStatementType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(SCPStatementType value) {
            this.type = value;
        }

        public SCPStatementPrepare getPrepare() {
            return this.prepare;
        }

        public void setPrepare(SCPStatementPrepare value) {
            this.prepare = value;
        }

        public SCPStatementConfirm getConfirm() {
            return this.confirm;
        }

        public void setConfirm(SCPStatementConfirm value) {
            this.confirm = value;
        }

        public SCPStatementExternalize getExternalize() {
            return this.externalize;
        }

        public void setExternalize(SCPStatementExternalize value) {
            this.externalize = value;
        }

        public SCPNomination getNominate() {
            return this.nominate;
        }

        public void setNominate(SCPNomination value) {
            this.nominate = value;
        }

        public static void encode(XdrDataOutputStream stream, SCPStatementPledges encodedSCPStatementPledges) throws IOException {
            stream.writeInt(encodedSCPStatementPledges.getDiscriminant().getValue());
            switch (encodedSCPStatementPledges.getDiscriminant()) {
                case SCP_ST_PREPARE: {
                    SCPStatementPrepare.encode(stream, encodedSCPStatementPledges.prepare);
                    break;
                }
                case SCP_ST_CONFIRM: {
                    SCPStatementConfirm.encode(stream, encodedSCPStatementPledges.confirm);
                    break;
                }
                case SCP_ST_EXTERNALIZE: {
                    SCPStatementExternalize.encode(stream, encodedSCPStatementPledges.externalize);
                    break;
                }
                case SCP_ST_NOMINATE: {
                    SCPNomination.encode(stream, encodedSCPStatementPledges.nominate);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            SCPStatementPledges.encode(stream, this);
        }

        public static SCPStatementPledges decode(XdrDataInputStream stream) throws IOException {
            SCPStatementPledges decodedSCPStatementPledges = new SCPStatementPledges();
            SCPStatementType discriminant = SCPStatementType.decode(stream);
            decodedSCPStatementPledges.setDiscriminant(discriminant);
            switch (decodedSCPStatementPledges.getDiscriminant()) {
                case SCP_ST_PREPARE: {
                    decodedSCPStatementPledges.prepare = SCPStatementPrepare.decode(stream);
                    break;
                }
                case SCP_ST_CONFIRM: {
                    decodedSCPStatementPledges.confirm = SCPStatementConfirm.decode(stream);
                    break;
                }
                case SCP_ST_EXTERNALIZE: {
                    decodedSCPStatementPledges.externalize = SCPStatementExternalize.decode(stream);
                    break;
                }
                case SCP_ST_NOMINATE: {
                    decodedSCPStatementPledges.nominate = SCPNomination.decode(stream);
                }
            }
            return decodedSCPStatementPledges;
        }

        public int hashCode() {
            return Objects.hash(this.prepare, this.confirm, this.externalize, this.nominate, this.type);
        }

        public boolean equals(Object object) {
            if (!(object instanceof SCPStatementPledges)) {
                return false;
            }
            SCPStatementPledges other = (SCPStatementPledges)object;
            return Objects.equals(this.prepare, other.prepare) && Objects.equals(this.confirm, other.confirm) && Objects.equals(this.externalize, other.externalize) && Objects.equals(this.nominate, other.nominate) && Objects.equals(this.type, other.type);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static SCPStatementPledges fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return SCPStatementPledges.fromXdrByteArray(bytes);
        }

        public static SCPStatementPledges fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return SCPStatementPledges.decode(xdrDataInputStream);
        }

        public static class SCPStatementPrepare
        implements XdrElement {
            private Hash quorumSetHash;
            private SCPBallot ballot;
            private SCPBallot prepared;
            private SCPBallot preparedPrime;
            private Uint32 nC;
            private Uint32 nH;

            public Hash getQuorumSetHash() {
                return this.quorumSetHash;
            }

            public void setQuorumSetHash(Hash value) {
                this.quorumSetHash = value;
            }

            public SCPBallot getBallot() {
                return this.ballot;
            }

            public void setBallot(SCPBallot value) {
                this.ballot = value;
            }

            public SCPBallot getPrepared() {
                return this.prepared;
            }

            public void setPrepared(SCPBallot value) {
                this.prepared = value;
            }

            public SCPBallot getPreparedPrime() {
                return this.preparedPrime;
            }

            public void setPreparedPrime(SCPBallot value) {
                this.preparedPrime = value;
            }

            public Uint32 getNC() {
                return this.nC;
            }

            public void setNC(Uint32 value) {
                this.nC = value;
            }

            public Uint32 getNH() {
                return this.nH;
            }

            public void setNH(Uint32 value) {
                this.nH = value;
            }

            public static void encode(XdrDataOutputStream stream, SCPStatementPrepare encodedSCPStatementPrepare) throws IOException {
                Hash.encode(stream, encodedSCPStatementPrepare.quorumSetHash);
                SCPBallot.encode(stream, encodedSCPStatementPrepare.ballot);
                if (encodedSCPStatementPrepare.prepared != null) {
                    stream.writeInt(1);
                    SCPBallot.encode(stream, encodedSCPStatementPrepare.prepared);
                } else {
                    stream.writeInt(0);
                }
                if (encodedSCPStatementPrepare.preparedPrime != null) {
                    stream.writeInt(1);
                    SCPBallot.encode(stream, encodedSCPStatementPrepare.preparedPrime);
                } else {
                    stream.writeInt(0);
                }
                Uint32.encode(stream, encodedSCPStatementPrepare.nC);
                Uint32.encode(stream, encodedSCPStatementPrepare.nH);
            }

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                SCPStatementPrepare.encode(stream, this);
            }

            public static SCPStatementPrepare decode(XdrDataInputStream stream) throws IOException {
                int preparedPrimePresent;
                SCPStatementPrepare decodedSCPStatementPrepare = new SCPStatementPrepare();
                decodedSCPStatementPrepare.quorumSetHash = Hash.decode(stream);
                decodedSCPStatementPrepare.ballot = SCPBallot.decode(stream);
                int preparedPresent = stream.readInt();
                if (preparedPresent != 0) {
                    decodedSCPStatementPrepare.prepared = SCPBallot.decode(stream);
                }
                if ((preparedPrimePresent = stream.readInt()) != 0) {
                    decodedSCPStatementPrepare.preparedPrime = SCPBallot.decode(stream);
                }
                decodedSCPStatementPrepare.nC = Uint32.decode(stream);
                decodedSCPStatementPrepare.nH = Uint32.decode(stream);
                return decodedSCPStatementPrepare;
            }

            public int hashCode() {
                return Objects.hash(this.quorumSetHash, this.ballot, this.prepared, this.preparedPrime, this.nC, this.nH);
            }

            public boolean equals(Object object) {
                if (!(object instanceof SCPStatementPrepare)) {
                    return false;
                }
                SCPStatementPrepare other = (SCPStatementPrepare)object;
                return Objects.equals(this.quorumSetHash, other.quorumSetHash) && Objects.equals(this.ballot, other.ballot) && Objects.equals(this.prepared, other.prepared) && Objects.equals(this.preparedPrime, other.preparedPrime) && Objects.equals(this.nC, other.nC) && Objects.equals(this.nH, other.nH);
            }

            @Override
            public String toXdrBase64() throws IOException {
                return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
            }

            @Override
            public byte[] toXdrByteArray() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
                this.encode(xdrDataOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            public static SCPStatementPrepare fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return SCPStatementPrepare.fromXdrByteArray(bytes);
            }

            public static SCPStatementPrepare fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return SCPStatementPrepare.decode(xdrDataInputStream);
            }

            public static final class Builder {
                private Hash quorumSetHash;
                private SCPBallot ballot;
                private SCPBallot prepared;
                private SCPBallot preparedPrime;
                private Uint32 nC;
                private Uint32 nH;

                public Builder quorumSetHash(Hash quorumSetHash) {
                    this.quorumSetHash = quorumSetHash;
                    return this;
                }

                public Builder ballot(SCPBallot ballot) {
                    this.ballot = ballot;
                    return this;
                }

                public Builder prepared(SCPBallot prepared) {
                    this.prepared = prepared;
                    return this;
                }

                public Builder preparedPrime(SCPBallot preparedPrime) {
                    this.preparedPrime = preparedPrime;
                    return this;
                }

                public Builder nC(Uint32 nC) {
                    this.nC = nC;
                    return this;
                }

                public Builder nH(Uint32 nH) {
                    this.nH = nH;
                    return this;
                }

                public SCPStatementPrepare build() {
                    SCPStatementPrepare val = new SCPStatementPrepare();
                    val.setQuorumSetHash(this.quorumSetHash);
                    val.setBallot(this.ballot);
                    val.setPrepared(this.prepared);
                    val.setPreparedPrime(this.preparedPrime);
                    val.setNC(this.nC);
                    val.setNH(this.nH);
                    return val;
                }
            }
        }

        public static class SCPStatementConfirm
        implements XdrElement {
            private SCPBallot ballot;
            private Uint32 nPrepared;
            private Uint32 nCommit;
            private Uint32 nH;
            private Hash quorumSetHash;

            public SCPBallot getBallot() {
                return this.ballot;
            }

            public void setBallot(SCPBallot value) {
                this.ballot = value;
            }

            public Uint32 getNPrepared() {
                return this.nPrepared;
            }

            public void setNPrepared(Uint32 value) {
                this.nPrepared = value;
            }

            public Uint32 getNCommit() {
                return this.nCommit;
            }

            public void setNCommit(Uint32 value) {
                this.nCommit = value;
            }

            public Uint32 getNH() {
                return this.nH;
            }

            public void setNH(Uint32 value) {
                this.nH = value;
            }

            public Hash getQuorumSetHash() {
                return this.quorumSetHash;
            }

            public void setQuorumSetHash(Hash value) {
                this.quorumSetHash = value;
            }

            public static void encode(XdrDataOutputStream stream, SCPStatementConfirm encodedSCPStatementConfirm) throws IOException {
                SCPBallot.encode(stream, encodedSCPStatementConfirm.ballot);
                Uint32.encode(stream, encodedSCPStatementConfirm.nPrepared);
                Uint32.encode(stream, encodedSCPStatementConfirm.nCommit);
                Uint32.encode(stream, encodedSCPStatementConfirm.nH);
                Hash.encode(stream, encodedSCPStatementConfirm.quorumSetHash);
            }

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                SCPStatementConfirm.encode(stream, this);
            }

            public static SCPStatementConfirm decode(XdrDataInputStream stream) throws IOException {
                SCPStatementConfirm decodedSCPStatementConfirm = new SCPStatementConfirm();
                decodedSCPStatementConfirm.ballot = SCPBallot.decode(stream);
                decodedSCPStatementConfirm.nPrepared = Uint32.decode(stream);
                decodedSCPStatementConfirm.nCommit = Uint32.decode(stream);
                decodedSCPStatementConfirm.nH = Uint32.decode(stream);
                decodedSCPStatementConfirm.quorumSetHash = Hash.decode(stream);
                return decodedSCPStatementConfirm;
            }

            public int hashCode() {
                return Objects.hash(this.ballot, this.nPrepared, this.nCommit, this.nH, this.quorumSetHash);
            }

            public boolean equals(Object object) {
                if (!(object instanceof SCPStatementConfirm)) {
                    return false;
                }
                SCPStatementConfirm other = (SCPStatementConfirm)object;
                return Objects.equals(this.ballot, other.ballot) && Objects.equals(this.nPrepared, other.nPrepared) && Objects.equals(this.nCommit, other.nCommit) && Objects.equals(this.nH, other.nH) && Objects.equals(this.quorumSetHash, other.quorumSetHash);
            }

            @Override
            public String toXdrBase64() throws IOException {
                return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
            }

            @Override
            public byte[] toXdrByteArray() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
                this.encode(xdrDataOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            public static SCPStatementConfirm fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return SCPStatementConfirm.fromXdrByteArray(bytes);
            }

            public static SCPStatementConfirm fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return SCPStatementConfirm.decode(xdrDataInputStream);
            }

            public static final class Builder {
                private SCPBallot ballot;
                private Uint32 nPrepared;
                private Uint32 nCommit;
                private Uint32 nH;
                private Hash quorumSetHash;

                public Builder ballot(SCPBallot ballot) {
                    this.ballot = ballot;
                    return this;
                }

                public Builder nPrepared(Uint32 nPrepared) {
                    this.nPrepared = nPrepared;
                    return this;
                }

                public Builder nCommit(Uint32 nCommit) {
                    this.nCommit = nCommit;
                    return this;
                }

                public Builder nH(Uint32 nH) {
                    this.nH = nH;
                    return this;
                }

                public Builder quorumSetHash(Hash quorumSetHash) {
                    this.quorumSetHash = quorumSetHash;
                    return this;
                }

                public SCPStatementConfirm build() {
                    SCPStatementConfirm val = new SCPStatementConfirm();
                    val.setBallot(this.ballot);
                    val.setNPrepared(this.nPrepared);
                    val.setNCommit(this.nCommit);
                    val.setNH(this.nH);
                    val.setQuorumSetHash(this.quorumSetHash);
                    return val;
                }
            }
        }

        public static class SCPStatementExternalize
        implements XdrElement {
            private SCPBallot commit;
            private Uint32 nH;
            private Hash commitQuorumSetHash;

            public SCPBallot getCommit() {
                return this.commit;
            }

            public void setCommit(SCPBallot value) {
                this.commit = value;
            }

            public Uint32 getNH() {
                return this.nH;
            }

            public void setNH(Uint32 value) {
                this.nH = value;
            }

            public Hash getCommitQuorumSetHash() {
                return this.commitQuorumSetHash;
            }

            public void setCommitQuorumSetHash(Hash value) {
                this.commitQuorumSetHash = value;
            }

            public static void encode(XdrDataOutputStream stream, SCPStatementExternalize encodedSCPStatementExternalize) throws IOException {
                SCPBallot.encode(stream, encodedSCPStatementExternalize.commit);
                Uint32.encode(stream, encodedSCPStatementExternalize.nH);
                Hash.encode(stream, encodedSCPStatementExternalize.commitQuorumSetHash);
            }

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                SCPStatementExternalize.encode(stream, this);
            }

            public static SCPStatementExternalize decode(XdrDataInputStream stream) throws IOException {
                SCPStatementExternalize decodedSCPStatementExternalize = new SCPStatementExternalize();
                decodedSCPStatementExternalize.commit = SCPBallot.decode(stream);
                decodedSCPStatementExternalize.nH = Uint32.decode(stream);
                decodedSCPStatementExternalize.commitQuorumSetHash = Hash.decode(stream);
                return decodedSCPStatementExternalize;
            }

            public int hashCode() {
                return Objects.hash(this.commit, this.nH, this.commitQuorumSetHash);
            }

            public boolean equals(Object object) {
                if (!(object instanceof SCPStatementExternalize)) {
                    return false;
                }
                SCPStatementExternalize other = (SCPStatementExternalize)object;
                return Objects.equals(this.commit, other.commit) && Objects.equals(this.nH, other.nH) && Objects.equals(this.commitQuorumSetHash, other.commitQuorumSetHash);
            }

            @Override
            public String toXdrBase64() throws IOException {
                return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
            }

            @Override
            public byte[] toXdrByteArray() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
                this.encode(xdrDataOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            public static SCPStatementExternalize fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return SCPStatementExternalize.fromXdrByteArray(bytes);
            }

            public static SCPStatementExternalize fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return SCPStatementExternalize.decode(xdrDataInputStream);
            }

            public static final class Builder {
                private SCPBallot commit;
                private Uint32 nH;
                private Hash commitQuorumSetHash;

                public Builder commit(SCPBallot commit) {
                    this.commit = commit;
                    return this;
                }

                public Builder nH(Uint32 nH) {
                    this.nH = nH;
                    return this;
                }

                public Builder commitQuorumSetHash(Hash commitQuorumSetHash) {
                    this.commitQuorumSetHash = commitQuorumSetHash;
                    return this;
                }

                public SCPStatementExternalize build() {
                    SCPStatementExternalize val = new SCPStatementExternalize();
                    val.setCommit(this.commit);
                    val.setNH(this.nH);
                    val.setCommitQuorumSetHash(this.commitQuorumSetHash);
                    return val;
                }
            }
        }

        public static final class Builder {
            private SCPStatementType discriminant;
            private SCPStatementPrepare prepare;
            private SCPStatementConfirm confirm;
            private SCPStatementExternalize externalize;
            private SCPNomination nominate;

            public Builder discriminant(SCPStatementType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder prepare(SCPStatementPrepare prepare) {
                this.prepare = prepare;
                return this;
            }

            public Builder confirm(SCPStatementConfirm confirm) {
                this.confirm = confirm;
                return this;
            }

            public Builder externalize(SCPStatementExternalize externalize) {
                this.externalize = externalize;
                return this;
            }

            public Builder nominate(SCPNomination nominate) {
                this.nominate = nominate;
                return this;
            }

            public SCPStatementPledges build() {
                SCPStatementPledges val = new SCPStatementPledges();
                val.setDiscriminant(this.discriminant);
                val.setPrepare(this.prepare);
                val.setConfirm(this.confirm);
                val.setExternalize(this.externalize);
                val.setNominate(this.nominate);
                return val;
            }
        }
    }

    public static final class Builder {
        private NodeID nodeID;
        private Uint64 slotIndex;
        private SCPStatementPledges pledges;

        public Builder nodeID(NodeID nodeID) {
            this.nodeID = nodeID;
            return this;
        }

        public Builder slotIndex(Uint64 slotIndex) {
            this.slotIndex = slotIndex;
            return this;
        }

        public Builder pledges(SCPStatementPledges pledges) {
            this.pledges = pledges;
            return this;
        }

        public SCPStatement build() {
            SCPStatement val = new SCPStatement();
            val.setNodeID(this.nodeID);
            val.setSlotIndex(this.slotIndex);
            val.setPledges(this.pledges);
            return val;
        }
    }
}

