/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SurveyResponseMessage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SignedSurveyResponseMessage
implements XdrElement {
    private Signature responseSignature;
    private SurveyResponseMessage response;

    public Signature getResponseSignature() {
        return this.responseSignature;
    }

    public void setResponseSignature(Signature value) {
        this.responseSignature = value;
    }

    public SurveyResponseMessage getResponse() {
        return this.response;
    }

    public void setResponse(SurveyResponseMessage value) {
        this.response = value;
    }

    public static void encode(XdrDataOutputStream stream, SignedSurveyResponseMessage encodedSignedSurveyResponseMessage) throws IOException {
        Signature.encode(stream, encodedSignedSurveyResponseMessage.responseSignature);
        SurveyResponseMessage.encode(stream, encodedSignedSurveyResponseMessage.response);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SignedSurveyResponseMessage.encode(stream, this);
    }

    public static SignedSurveyResponseMessage decode(XdrDataInputStream stream) throws IOException {
        SignedSurveyResponseMessage decodedSignedSurveyResponseMessage = new SignedSurveyResponseMessage();
        decodedSignedSurveyResponseMessage.responseSignature = Signature.decode(stream);
        decodedSignedSurveyResponseMessage.response = SurveyResponseMessage.decode(stream);
        return decodedSignedSurveyResponseMessage;
    }

    public int hashCode() {
        return Objects.hash(this.responseSignature, this.response);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignedSurveyResponseMessage)) {
            return false;
        }
        SignedSurveyResponseMessage other = (SignedSurveyResponseMessage)object;
        return Objects.equals(this.responseSignature, other.responseSignature) && Objects.equals(this.response, other.response);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SignedSurveyResponseMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SignedSurveyResponseMessage.fromXdrByteArray(bytes);
    }

    public static SignedSurveyResponseMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SignedSurveyResponseMessage.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Signature responseSignature;
        private SurveyResponseMessage response;

        public Builder responseSignature(Signature responseSignature) {
            this.responseSignature = responseSignature;
            return this;
        }

        public Builder response(SurveyResponseMessage response) {
            this.response = response;
            return this;
        }

        public SignedSurveyResponseMessage build() {
            SignedSurveyResponseMessage val = new SignedSurveyResponseMessage();
            val.setResponseSignature(this.responseSignature);
            val.setResponse(this.response);
            return val;
        }
    }
}

