/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.CreateContractArgs;
import org.stellar.sdk.xdr.InvokeContractArgs;
import org.stellar.sdk.xdr.SorobanAuthorizedFunctionType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanAuthorizedFunction
implements XdrElement {
    SorobanAuthorizedFunctionType type;
    private InvokeContractArgs contractFn;
    private CreateContractArgs createContractHostFn;

    public SorobanAuthorizedFunctionType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(SorobanAuthorizedFunctionType value) {
        this.type = value;
    }

    public InvokeContractArgs getContractFn() {
        return this.contractFn;
    }

    public void setContractFn(InvokeContractArgs value) {
        this.contractFn = value;
    }

    public CreateContractArgs getCreateContractHostFn() {
        return this.createContractHostFn;
    }

    public void setCreateContractHostFn(CreateContractArgs value) {
        this.createContractHostFn = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanAuthorizedFunction encodedSorobanAuthorizedFunction) throws IOException {
        stream.writeInt(encodedSorobanAuthorizedFunction.getDiscriminant().getValue());
        switch (encodedSorobanAuthorizedFunction.getDiscriminant()) {
            case SOROBAN_AUTHORIZED_FUNCTION_TYPE_CONTRACT_FN: {
                InvokeContractArgs.encode(stream, encodedSorobanAuthorizedFunction.contractFn);
                break;
            }
            case SOROBAN_AUTHORIZED_FUNCTION_TYPE_CREATE_CONTRACT_HOST_FN: {
                CreateContractArgs.encode(stream, encodedSorobanAuthorizedFunction.createContractHostFn);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanAuthorizedFunction.encode(stream, this);
    }

    public static SorobanAuthorizedFunction decode(XdrDataInputStream stream) throws IOException {
        SorobanAuthorizedFunction decodedSorobanAuthorizedFunction = new SorobanAuthorizedFunction();
        SorobanAuthorizedFunctionType discriminant = SorobanAuthorizedFunctionType.decode(stream);
        decodedSorobanAuthorizedFunction.setDiscriminant(discriminant);
        switch (decodedSorobanAuthorizedFunction.getDiscriminant()) {
            case SOROBAN_AUTHORIZED_FUNCTION_TYPE_CONTRACT_FN: {
                decodedSorobanAuthorizedFunction.contractFn = InvokeContractArgs.decode(stream);
                break;
            }
            case SOROBAN_AUTHORIZED_FUNCTION_TYPE_CREATE_CONTRACT_HOST_FN: {
                decodedSorobanAuthorizedFunction.createContractHostFn = CreateContractArgs.decode(stream);
            }
        }
        return decodedSorobanAuthorizedFunction;
    }

    public int hashCode() {
        return Objects.hash(this.contractFn, this.createContractHostFn, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanAuthorizedFunction)) {
            return false;
        }
        SorobanAuthorizedFunction other = (SorobanAuthorizedFunction)object;
        return Objects.equals(this.contractFn, other.contractFn) && Objects.equals(this.createContractHostFn, other.createContractHostFn) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanAuthorizedFunction fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanAuthorizedFunction.fromXdrByteArray(bytes);
    }

    public static SorobanAuthorizedFunction fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanAuthorizedFunction.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SorobanAuthorizedFunctionType discriminant;
        private InvokeContractArgs contractFn;
        private CreateContractArgs createContractHostFn;

        public Builder discriminant(SorobanAuthorizedFunctionType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder contractFn(InvokeContractArgs contractFn) {
            this.contractFn = contractFn;
            return this;
        }

        public Builder createContractHostFn(CreateContractArgs createContractHostFn) {
            this.createContractHostFn = createContractHostFn;
            return this;
        }

        public SorobanAuthorizedFunction build() {
            SorobanAuthorizedFunction val = new SorobanAuthorizedFunction();
            val.setDiscriminant(this.discriminant);
            val.setContractFn(this.contractFn);
            val.setCreateContractHostFn(this.createContractHostFn);
            return val;
        }
    }
}

