/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SorobanResources;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanTransactionData
implements XdrElement {
    private ExtensionPoint ext;
    private SorobanResources resources;
    private Int64 resourceFee;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public SorobanResources getResources() {
        return this.resources;
    }

    public void setResources(SorobanResources value) {
        this.resources = value;
    }

    public Int64 getResourceFee() {
        return this.resourceFee;
    }

    public void setResourceFee(Int64 value) {
        this.resourceFee = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanTransactionData encodedSorobanTransactionData) throws IOException {
        ExtensionPoint.encode(stream, encodedSorobanTransactionData.ext);
        SorobanResources.encode(stream, encodedSorobanTransactionData.resources);
        Int64.encode(stream, encodedSorobanTransactionData.resourceFee);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanTransactionData.encode(stream, this);
    }

    public static SorobanTransactionData decode(XdrDataInputStream stream) throws IOException {
        SorobanTransactionData decodedSorobanTransactionData = new SorobanTransactionData();
        decodedSorobanTransactionData.ext = ExtensionPoint.decode(stream);
        decodedSorobanTransactionData.resources = SorobanResources.decode(stream);
        decodedSorobanTransactionData.resourceFee = Int64.decode(stream);
        return decodedSorobanTransactionData;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.resources, this.resourceFee);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanTransactionData)) {
            return false;
        }
        SorobanTransactionData other = (SorobanTransactionData)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.resources, other.resources) && Objects.equals(this.resourceFee, other.resourceFee);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanTransactionData fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanTransactionData.fromXdrByteArray(bytes);
    }

    public static SorobanTransactionData fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanTransactionData.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private SorobanResources resources;
        private Int64 resourceFee;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder resources(SorobanResources resources) {
            this.resources = resources;
            return this;
        }

        public Builder resourceFee(Int64 resourceFee) {
            this.resourceFee = resourceFee;
            return this;
        }

        public SorobanTransactionData build() {
            SorobanTransactionData val = new SorobanTransactionData();
            val.setExt(this.ext);
            val.setResources(this.resources);
            val.setResourceFee(this.resourceFee);
            return val;
        }
    }
}

