/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMetaV2
implements XdrElement {
    private LedgerEntryChanges txChangesBefore;
    private OperationMeta[] operations;
    private LedgerEntryChanges txChangesAfter;

    public LedgerEntryChanges getTxChangesBefore() {
        return this.txChangesBefore;
    }

    public void setTxChangesBefore(LedgerEntryChanges value) {
        this.txChangesBefore = value;
    }

    public OperationMeta[] getOperations() {
        return this.operations;
    }

    public void setOperations(OperationMeta[] value) {
        this.operations = value;
    }

    public LedgerEntryChanges getTxChangesAfter() {
        return this.txChangesAfter;
    }

    public void setTxChangesAfter(LedgerEntryChanges value) {
        this.txChangesAfter = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionMetaV2 encodedTransactionMetaV2) throws IOException {
        LedgerEntryChanges.encode(stream, encodedTransactionMetaV2.txChangesBefore);
        int operationssize = encodedTransactionMetaV2.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; ++i) {
            OperationMeta.encode(stream, encodedTransactionMetaV2.operations[i]);
        }
        LedgerEntryChanges.encode(stream, encodedTransactionMetaV2.txChangesAfter);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionMetaV2.encode(stream, this);
    }

    public static TransactionMetaV2 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV2 decodedTransactionMetaV2 = new TransactionMetaV2();
        decodedTransactionMetaV2.txChangesBefore = LedgerEntryChanges.decode(stream);
        int operationssize = stream.readInt();
        decodedTransactionMetaV2.operations = new OperationMeta[operationssize];
        for (int i = 0; i < operationssize; ++i) {
            decodedTransactionMetaV2.operations[i] = OperationMeta.decode(stream);
        }
        decodedTransactionMetaV2.txChangesAfter = LedgerEntryChanges.decode(stream);
        return decodedTransactionMetaV2;
    }

    public int hashCode() {
        return Objects.hash(this.txChangesBefore, Arrays.hashCode(this.operations), this.txChangesAfter);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionMetaV2)) {
            return false;
        }
        TransactionMetaV2 other = (TransactionMetaV2)object;
        return Objects.equals(this.txChangesBefore, other.txChangesBefore) && Arrays.equals(this.operations, other.operations) && Objects.equals(this.txChangesAfter, other.txChangesAfter);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TransactionMetaV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMetaV2.fromXdrByteArray(bytes);
    }

    public static TransactionMetaV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMetaV2.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LedgerEntryChanges txChangesBefore;
        private OperationMeta[] operations;
        private LedgerEntryChanges txChangesAfter;

        public Builder txChangesBefore(LedgerEntryChanges txChangesBefore) {
            this.txChangesBefore = txChangesBefore;
            return this;
        }

        public Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        public Builder txChangesAfter(LedgerEntryChanges txChangesAfter) {
            this.txChangesAfter = txChangesAfter;
            return this;
        }

        public TransactionMetaV2 build() {
            TransactionMetaV2 val = new TransactionMetaV2();
            val.setTxChangesBefore(this.txChangesBefore);
            val.setOperations(this.operations);
            val.setTxChangesAfter(this.txChangesAfter);
            return val;
        }
    }
}

