/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.TransactionMeta;
import org.stellar.sdk.xdr.TransactionResultPair;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionResultMeta
implements XdrElement {
    private TransactionResultPair result;
    private LedgerEntryChanges feeProcessing;
    private TransactionMeta txApplyProcessing;

    public TransactionResultPair getResult() {
        return this.result;
    }

    public void setResult(TransactionResultPair value) {
        this.result = value;
    }

    public LedgerEntryChanges getFeeProcessing() {
        return this.feeProcessing;
    }

    public void setFeeProcessing(LedgerEntryChanges value) {
        this.feeProcessing = value;
    }

    public TransactionMeta getTxApplyProcessing() {
        return this.txApplyProcessing;
    }

    public void setTxApplyProcessing(TransactionMeta value) {
        this.txApplyProcessing = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionResultMeta encodedTransactionResultMeta) throws IOException {
        TransactionResultPair.encode(stream, encodedTransactionResultMeta.result);
        LedgerEntryChanges.encode(stream, encodedTransactionResultMeta.feeProcessing);
        TransactionMeta.encode(stream, encodedTransactionResultMeta.txApplyProcessing);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionResultMeta.encode(stream, this);
    }

    public static TransactionResultMeta decode(XdrDataInputStream stream) throws IOException {
        TransactionResultMeta decodedTransactionResultMeta = new TransactionResultMeta();
        decodedTransactionResultMeta.result = TransactionResultPair.decode(stream);
        decodedTransactionResultMeta.feeProcessing = LedgerEntryChanges.decode(stream);
        decodedTransactionResultMeta.txApplyProcessing = TransactionMeta.decode(stream);
        return decodedTransactionResultMeta;
    }

    public int hashCode() {
        return Objects.hash(this.result, this.feeProcessing, this.txApplyProcessing);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionResultMeta)) {
            return false;
        }
        TransactionResultMeta other = (TransactionResultMeta)object;
        return Objects.equals(this.result, other.result) && Objects.equals(this.feeProcessing, other.feeProcessing) && Objects.equals(this.txApplyProcessing, other.txApplyProcessing);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TransactionResultMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionResultMeta.fromXdrByteArray(bytes);
    }

    public static TransactionResultMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionResultMeta.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private TransactionResultPair result;
        private LedgerEntryChanges feeProcessing;
        private TransactionMeta txApplyProcessing;

        public Builder result(TransactionResultPair result) {
            this.result = result;
            return this;
        }

        public Builder feeProcessing(LedgerEntryChanges feeProcessing) {
            this.feeProcessing = feeProcessing;
            return this;
        }

        public Builder txApplyProcessing(TransactionMeta txApplyProcessing) {
            this.txApplyProcessing = txApplyProcessing;
            return this;
        }

        public TransactionResultMeta build() {
            TransactionResultMeta val = new TransactionResultMeta();
            val.setResult(this.result);
            val.setFeeProcessing(this.feeProcessing);
            val.setTxApplyProcessing(this.txApplyProcessing);
            return val;
        }
    }
}

