/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AlphaNum4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TrustLineAsset
implements XdrElement {
    AssetType type;
    private AlphaNum4 alphaNum4;
    private AlphaNum12 alphaNum12;
    private PoolID liquidityPoolID;

    public AssetType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(AssetType value) {
        this.type = value;
    }

    public AlphaNum4 getAlphaNum4() {
        return this.alphaNum4;
    }

    public void setAlphaNum4(AlphaNum4 value) {
        this.alphaNum4 = value;
    }

    public AlphaNum12 getAlphaNum12() {
        return this.alphaNum12;
    }

    public void setAlphaNum12(AlphaNum12 value) {
        this.alphaNum12 = value;
    }

    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    public void setLiquidityPoolID(PoolID value) {
        this.liquidityPoolID = value;
    }

    public static void encode(XdrDataOutputStream stream, TrustLineAsset encodedTrustLineAsset) throws IOException {
        stream.writeInt(encodedTrustLineAsset.getDiscriminant().getValue());
        switch (encodedTrustLineAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                AlphaNum4.encode(stream, encodedTrustLineAsset.alphaNum4);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                AlphaNum12.encode(stream, encodedTrustLineAsset.alphaNum12);
                break;
            }
            case ASSET_TYPE_POOL_SHARE: {
                PoolID.encode(stream, encodedTrustLineAsset.liquidityPoolID);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TrustLineAsset.encode(stream, this);
    }

    public static TrustLineAsset decode(XdrDataInputStream stream) throws IOException {
        TrustLineAsset decodedTrustLineAsset = new TrustLineAsset();
        AssetType discriminant = AssetType.decode(stream);
        decodedTrustLineAsset.setDiscriminant(discriminant);
        switch (decodedTrustLineAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedTrustLineAsset.alphaNum4 = AlphaNum4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedTrustLineAsset.alphaNum12 = AlphaNum12.decode(stream);
                break;
            }
            case ASSET_TYPE_POOL_SHARE: {
                decodedTrustLineAsset.liquidityPoolID = PoolID.decode(stream);
            }
        }
        return decodedTrustLineAsset;
    }

    public int hashCode() {
        return Objects.hash(this.alphaNum4, this.alphaNum12, this.liquidityPoolID, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrustLineAsset)) {
            return false;
        }
        TrustLineAsset other = (TrustLineAsset)object;
        return Objects.equals(this.alphaNum4, other.alphaNum4) && Objects.equals(this.alphaNum12, other.alphaNum12) && Objects.equals(this.liquidityPoolID, other.liquidityPoolID) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TrustLineAsset fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TrustLineAsset.fromXdrByteArray(bytes);
    }

    public static TrustLineAsset fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TrustLineAsset.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AssetType discriminant;
        private AlphaNum4 alphaNum4;
        private AlphaNum12 alphaNum12;
        private PoolID liquidityPoolID;

        public Builder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder alphaNum4(AlphaNum4 alphaNum4) {
            this.alphaNum4 = alphaNum4;
            return this;
        }

        public Builder alphaNum12(AlphaNum12 alphaNum12) {
            this.alphaNum12 = alphaNum12;
            return this;
        }

        public Builder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        public TrustLineAsset build() {
            TrustLineAsset val = new TrustLineAsset();
            val.setDiscriminant(this.discriminant);
            val.setAlphaNum4(this.alphaNum4);
            val.setAlphaNum12(this.alphaNum12);
            val.setLiquidityPoolID(this.liquidityPoolID);
            return val;
        }
    }
}

