/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Liabilities;
import org.stellar.sdk.xdr.TrustLineAsset;
import org.stellar.sdk.xdr.TrustLineEntryExtensionV2;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TrustLineEntry
implements XdrElement {
    private AccountID accountID;
    private TrustLineAsset asset;
    private Int64 balance;
    private Int64 limit;
    private Uint32 flags;
    private TrustLineEntryExt ext;

    public AccountID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(AccountID value) {
        this.accountID = value;
    }

    public TrustLineAsset getAsset() {
        return this.asset;
    }

    public void setAsset(TrustLineAsset value) {
        this.asset = value;
    }

    public Int64 getBalance() {
        return this.balance;
    }

    public void setBalance(Int64 value) {
        this.balance = value;
    }

    public Int64 getLimit() {
        return this.limit;
    }

    public void setLimit(Int64 value) {
        this.limit = value;
    }

    public Uint32 getFlags() {
        return this.flags;
    }

    public void setFlags(Uint32 value) {
        this.flags = value;
    }

    public TrustLineEntryExt getExt() {
        return this.ext;
    }

    public void setExt(TrustLineEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, TrustLineEntry encodedTrustLineEntry) throws IOException {
        AccountID.encode(stream, encodedTrustLineEntry.accountID);
        TrustLineAsset.encode(stream, encodedTrustLineEntry.asset);
        Int64.encode(stream, encodedTrustLineEntry.balance);
        Int64.encode(stream, encodedTrustLineEntry.limit);
        Uint32.encode(stream, encodedTrustLineEntry.flags);
        TrustLineEntryExt.encode(stream, encodedTrustLineEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TrustLineEntry.encode(stream, this);
    }

    public static TrustLineEntry decode(XdrDataInputStream stream) throws IOException {
        TrustLineEntry decodedTrustLineEntry = new TrustLineEntry();
        decodedTrustLineEntry.accountID = AccountID.decode(stream);
        decodedTrustLineEntry.asset = TrustLineAsset.decode(stream);
        decodedTrustLineEntry.balance = Int64.decode(stream);
        decodedTrustLineEntry.limit = Int64.decode(stream);
        decodedTrustLineEntry.flags = Uint32.decode(stream);
        decodedTrustLineEntry.ext = TrustLineEntryExt.decode(stream);
        return decodedTrustLineEntry;
    }

    public int hashCode() {
        return Objects.hash(this.accountID, this.asset, this.balance, this.limit, this.flags, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrustLineEntry)) {
            return false;
        }
        TrustLineEntry other = (TrustLineEntry)object;
        return Objects.equals(this.accountID, other.accountID) && Objects.equals(this.asset, other.asset) && Objects.equals(this.balance, other.balance) && Objects.equals(this.limit, other.limit) && Objects.equals(this.flags, other.flags) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TrustLineEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TrustLineEntry.fromXdrByteArray(bytes);
    }

    public static TrustLineEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TrustLineEntry.decode(xdrDataInputStream);
    }

    public static class TrustLineEntryExt
    implements XdrElement {
        Integer v;
        private TrustLineEntryV1 v1;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public TrustLineEntryV1 getV1() {
            return this.v1;
        }

        public void setV1(TrustLineEntryV1 value) {
            this.v1 = value;
        }

        public static void encode(XdrDataOutputStream stream, TrustLineEntryExt encodedTrustLineEntryExt) throws IOException {
            stream.writeInt(encodedTrustLineEntryExt.getDiscriminant());
            switch (encodedTrustLineEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    TrustLineEntryV1.encode(stream, encodedTrustLineEntryExt.v1);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            TrustLineEntryExt.encode(stream, this);
        }

        public static TrustLineEntryExt decode(XdrDataInputStream stream) throws IOException {
            TrustLineEntryExt decodedTrustLineEntryExt = new TrustLineEntryExt();
            Integer discriminant = stream.readInt();
            decodedTrustLineEntryExt.setDiscriminant(discriminant);
            switch (decodedTrustLineEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedTrustLineEntryExt.v1 = TrustLineEntryV1.decode(stream);
                }
            }
            return decodedTrustLineEntryExt;
        }

        public int hashCode() {
            return Objects.hash(this.v1, this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TrustLineEntryExt)) {
                return false;
            }
            TrustLineEntryExt other = (TrustLineEntryExt)object;
            return Objects.equals(this.v1, other.v1) && Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static TrustLineEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TrustLineEntryExt.fromXdrByteArray(bytes);
        }

        public static TrustLineEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TrustLineEntryExt.decode(xdrDataInputStream);
        }

        public static class TrustLineEntryV1
        implements XdrElement {
            private Liabilities liabilities;
            private TrustLineEntryV1Ext ext;

            public Liabilities getLiabilities() {
                return this.liabilities;
            }

            public void setLiabilities(Liabilities value) {
                this.liabilities = value;
            }

            public TrustLineEntryV1Ext getExt() {
                return this.ext;
            }

            public void setExt(TrustLineEntryV1Ext value) {
                this.ext = value;
            }

            public static void encode(XdrDataOutputStream stream, TrustLineEntryV1 encodedTrustLineEntryV1) throws IOException {
                Liabilities.encode(stream, encodedTrustLineEntryV1.liabilities);
                TrustLineEntryV1Ext.encode(stream, encodedTrustLineEntryV1.ext);
            }

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                TrustLineEntryV1.encode(stream, this);
            }

            public static TrustLineEntryV1 decode(XdrDataInputStream stream) throws IOException {
                TrustLineEntryV1 decodedTrustLineEntryV1 = new TrustLineEntryV1();
                decodedTrustLineEntryV1.liabilities = Liabilities.decode(stream);
                decodedTrustLineEntryV1.ext = TrustLineEntryV1Ext.decode(stream);
                return decodedTrustLineEntryV1;
            }

            public int hashCode() {
                return Objects.hash(this.liabilities, this.ext);
            }

            public boolean equals(Object object) {
                if (!(object instanceof TrustLineEntryV1)) {
                    return false;
                }
                TrustLineEntryV1 other = (TrustLineEntryV1)object;
                return Objects.equals(this.liabilities, other.liabilities) && Objects.equals(this.ext, other.ext);
            }

            @Override
            public String toXdrBase64() throws IOException {
                return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
            }

            @Override
            public byte[] toXdrByteArray() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
                this.encode(xdrDataOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            public static TrustLineEntryV1 fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return TrustLineEntryV1.fromXdrByteArray(bytes);
            }

            public static TrustLineEntryV1 fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return TrustLineEntryV1.decode(xdrDataInputStream);
            }

            public static class TrustLineEntryV1Ext
            implements XdrElement {
                Integer v;
                private TrustLineEntryExtensionV2 v2;

                public Integer getDiscriminant() {
                    return this.v;
                }

                public void setDiscriminant(Integer value) {
                    this.v = value;
                }

                public TrustLineEntryExtensionV2 getV2() {
                    return this.v2;
                }

                public void setV2(TrustLineEntryExtensionV2 value) {
                    this.v2 = value;
                }

                public static void encode(XdrDataOutputStream stream, TrustLineEntryV1Ext encodedTrustLineEntryV1Ext) throws IOException {
                    stream.writeInt(encodedTrustLineEntryV1Ext.getDiscriminant());
                    switch (encodedTrustLineEntryV1Ext.getDiscriminant()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            TrustLineEntryExtensionV2.encode(stream, encodedTrustLineEntryV1Ext.v2);
                        }
                    }
                }

                @Override
                public void encode(XdrDataOutputStream stream) throws IOException {
                    TrustLineEntryV1Ext.encode(stream, this);
                }

                public static TrustLineEntryV1Ext decode(XdrDataInputStream stream) throws IOException {
                    TrustLineEntryV1Ext decodedTrustLineEntryV1Ext = new TrustLineEntryV1Ext();
                    Integer discriminant = stream.readInt();
                    decodedTrustLineEntryV1Ext.setDiscriminant(discriminant);
                    switch (decodedTrustLineEntryV1Ext.getDiscriminant()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            decodedTrustLineEntryV1Ext.v2 = TrustLineEntryExtensionV2.decode(stream);
                        }
                    }
                    return decodedTrustLineEntryV1Ext;
                }

                public int hashCode() {
                    return Objects.hash(this.v2, this.v);
                }

                public boolean equals(Object object) {
                    if (!(object instanceof TrustLineEntryV1Ext)) {
                        return false;
                    }
                    TrustLineEntryV1Ext other = (TrustLineEntryV1Ext)object;
                    return Objects.equals(this.v2, other.v2) && Objects.equals(this.v, other.v);
                }

                @Override
                public String toXdrBase64() throws IOException {
                    return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
                }

                @Override
                public byte[] toXdrByteArray() throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
                    this.encode(xdrDataOutputStream);
                    return byteArrayOutputStream.toByteArray();
                }

                public static TrustLineEntryV1Ext fromXdrBase64(String xdr) throws IOException {
                    byte[] bytes = Base64Factory.getInstance().decode(xdr);
                    return TrustLineEntryV1Ext.fromXdrByteArray(bytes);
                }

                public static TrustLineEntryV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                    return TrustLineEntryV1Ext.decode(xdrDataInputStream);
                }

                public static final class Builder {
                    private Integer discriminant;
                    private TrustLineEntryExtensionV2 v2;

                    public Builder discriminant(Integer discriminant) {
                        this.discriminant = discriminant;
                        return this;
                    }

                    public Builder v2(TrustLineEntryExtensionV2 v2) {
                        this.v2 = v2;
                        return this;
                    }

                    public TrustLineEntryV1Ext build() {
                        TrustLineEntryV1Ext val = new TrustLineEntryV1Ext();
                        val.setDiscriminant(this.discriminant);
                        val.setV2(this.v2);
                        return val;
                    }
                }
            }

            public static final class Builder {
                private Liabilities liabilities;
                private TrustLineEntryV1Ext ext;

                public Builder liabilities(Liabilities liabilities) {
                    this.liabilities = liabilities;
                    return this;
                }

                public Builder ext(TrustLineEntryV1Ext ext) {
                    this.ext = ext;
                    return this;
                }

                public TrustLineEntryV1 build() {
                    TrustLineEntryV1 val = new TrustLineEntryV1();
                    val.setLiabilities(this.liabilities);
                    val.setExt(this.ext);
                    return val;
                }
            }
        }

        public static final class Builder {
            private Integer discriminant;
            private TrustLineEntryV1 v1;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder v1(TrustLineEntryV1 v1) {
                this.v1 = v1;
                return this;
            }

            public TrustLineEntryExt build() {
                TrustLineEntryExt val = new TrustLineEntryExt();
                val.setDiscriminant(this.discriminant);
                val.setV1(this.v1);
                return val;
            }
        }
    }

    public static final class Builder {
        private AccountID accountID;
        private TrustLineAsset asset;
        private Int64 balance;
        private Int64 limit;
        private Uint32 flags;
        private TrustLineEntryExt ext;

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder asset(TrustLineAsset asset) {
            this.asset = asset;
            return this;
        }

        public Builder balance(Int64 balance) {
            this.balance = balance;
            return this;
        }

        public Builder limit(Int64 limit) {
            this.limit = limit;
            return this;
        }

        public Builder flags(Uint32 flags) {
            this.flags = flags;
            return this;
        }

        public Builder ext(TrustLineEntryExt ext) {
            this.ext = ext;
            return this;
        }

        public TrustLineEntry build() {
            TrustLineEntry val = new TrustLineEntry();
            val.setAccountID(this.accountID);
            val.setAsset(this.asset);
            val.setBalance(this.balance);
            val.setLimit(this.limit);
            val.setFlags(this.flags);
            val.setExt(this.ext);
            return val;
        }
    }
}

