/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.MuxedAccount;

public class AccountConverter {
    private final boolean enableMuxed;

    public static AccountConverter enableMuxed() {
        return new AccountConverter(true);
    }

    public static AccountConverter disableMuxed() {
        return new AccountConverter(false);
    }

    public MuxedAccount encode(String account) {
        MuxedAccount muxed = StrKey.encodeToXDRMuxedAccount(account);
        if (this.enableMuxed || muxed.getDiscriminant().equals(CryptoKeyType.KEY_TYPE_ED25519)) {
            return muxed;
        }
        MuxedAccount.MuxedAccountMed25519 med25519 = muxed.getMed25519();
        muxed.setDiscriminant(CryptoKeyType.KEY_TYPE_ED25519);
        muxed.setEd25519(med25519.getEd25519());
        return muxed;
    }

    public String decode(MuxedAccount account) {
        if (this.enableMuxed || account.getDiscriminant().equals(CryptoKeyType.KEY_TYPE_ED25519)) {
            return StrKey.encodeStellarMuxedAccount(account);
        }
        return StrKey.encodeEd25519PublicKey(StrKey.muxedAccountToAccountId(account));
    }

    @Generated
    private AccountConverter(boolean enableMuxed) {
        this.enableMuxed = enableMuxed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountConverter)) {
            return false;
        }
        AccountConverter other = (AccountConverter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.enableMuxed == other.enableMuxed;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountConverter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enableMuxed ? 79 : 97);
        return result;
    }
}

