/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.ChangeTrustAsset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ChangeTrustOperation
extends Operation {
    @NonNull
    private final ChangeTrustAsset asset;
    @NonNull
    private final String limit;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ChangeTrustOp op = new ChangeTrustOp();
        op.setLine(this.asset.toXdr());
        Int64 limit = new Int64();
        limit.setInt64(Operation.toXdrAmount(this.limit));
        op.setLimit(limit);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CHANGE_TRUST);
        body.setChangeTrustOp(op);
        return body;
    }

    @NonNull
    @Generated
    public ChangeTrustAsset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public String getLimit() {
        return this.limit;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTrustOperation)) {
            return false;
        }
        ChangeTrustOperation other = (ChangeTrustOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChangeTrustAsset this$asset = this.getAsset();
        ChangeTrustAsset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        String this$limit = this.getLimit();
        String other$limit = other.getLimit();
        return !(this$limit == null ? other$limit != null : !this$limit.equals(other$limit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeTrustOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ChangeTrustAsset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        String $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : $limit.hashCode());
        return result;
    }

    @Generated
    private ChangeTrustOperation(@NonNull ChangeTrustAsset asset, @NonNull String limit) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        this.asset = asset;
        this.limit = limit;
    }

    public static class Builder {
        private final ChangeTrustAsset asset;
        private final String limit;
        private String sourceAccount;

        Builder(ChangeTrustOp op) {
            this.asset = ChangeTrustAsset.fromXdr(op.getLine());
            this.limit = Operation.fromXdrAmount(op.getLimit().getInt64());
        }

        public Builder(@NonNull ChangeTrustAsset asset, @NonNull String limit) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.asset = asset;
            this.limit = limit;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public ChangeTrustOperation build() {
            ChangeTrustOperation operation = new ChangeTrustOperation(this.asset, this.limit);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

