/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeClaimableBalanceSponsorshipOperation
extends Operation {
    @NonNull
    private final String balanceId;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ClaimableBalanceID balanceId;
        byte[] balanceIdBytes = Util.hexToBytes(this.balanceId);
        try {
            balanceId = ClaimableBalanceID.fromXdrByteArray(balanceIdBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid balanceId: " + this.balanceId, e);
        }
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.CLAIMABLE_BALANCE);
        LedgerKey.LedgerKeyClaimableBalance claimableBalance = new LedgerKey.LedgerKeyClaimableBalance();
        claimableBalance.setBalanceID(balanceId);
        key.setClaimableBalance(claimableBalance);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getBalanceId() {
        return this.balanceId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeClaimableBalanceSponsorshipOperation)) {
            return false;
        }
        RevokeClaimableBalanceSponsorshipOperation other = (RevokeClaimableBalanceSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$balanceId = this.getBalanceId();
        String other$balanceId = other.getBalanceId();
        return !(this$balanceId == null ? other$balanceId != null : !this$balanceId.equals(other$balanceId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeClaimableBalanceSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $balanceId = this.getBalanceId();
        result = result * 59 + ($balanceId == null ? 43 : $balanceId.hashCode());
        return result;
    }

    @Generated
    private RevokeClaimableBalanceSponsorshipOperation(@NonNull String balanceId) {
        if (balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
        this.balanceId = balanceId;
    }

    public static class Builder {
        private final String balanceId;
        private String sourceAccount;

        Builder(RevokeSponsorshipOp op) {
            try {
                this.balanceId = Util.bytesToHex(op.getLedgerKey().getClaimableBalance().getBalanceID().toXdrByteArray()).toLowerCase();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid claimableBalance in the operation", e);
            }
        }

        public Builder(String balanceId) {
            this.balanceId = balanceId;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public RevokeClaimableBalanceSponsorshipOperation build() {
            RevokeClaimableBalanceSponsorshipOperation operation = new RevokeClaimableBalanceSponsorshipOperation(this.balanceId);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

