/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeOfferSponsorshipOperation
extends Operation {
    @NonNull
    private final String seller;
    @NonNull
    private final Long offerId;

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.OFFER);
        LedgerKey.LedgerKeyOffer offer = new LedgerKey.LedgerKeyOffer();
        Int64 id = new Int64();
        id.setInt64(this.offerId);
        offer.setOfferID(id);
        offer.setSellerID(StrKey.encodeToXDRAccountId(this.seller));
        key.setOffer(offer);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @NonNull
    @Generated
    public String getSeller() {
        return this.seller;
    }

    @NonNull
    @Generated
    public Long getOfferId() {
        return this.offerId;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeOfferSponsorshipOperation)) {
            return false;
        }
        RevokeOfferSponsorshipOperation other = (RevokeOfferSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$offerId = this.getOfferId();
        Long other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !((Object)this$offerId).equals(other$offerId)) {
            return false;
        }
        String this$seller = this.getSeller();
        String other$seller = other.getSeller();
        return !(this$seller == null ? other$seller != null : !this$seller.equals(other$seller));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeOfferSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : ((Object)$offerId).hashCode());
        String $seller = this.getSeller();
        result = result * 59 + ($seller == null ? 43 : $seller.hashCode());
        return result;
    }

    @Generated
    private RevokeOfferSponsorshipOperation(@NonNull String seller, @NonNull Long offerId) {
        if (seller == null) {
            throw new NullPointerException("seller is marked non-null but is null");
        }
        if (offerId == null) {
            throw new NullPointerException("offerId is marked non-null but is null");
        }
        this.seller = seller;
        this.offerId = offerId;
    }

    public static class Builder {
        private final String seller;
        private final Long offerId;
        private String sourceAccount;

        Builder(RevokeSponsorshipOp op) {
            this.offerId = op.getLedgerKey().getOffer().getOfferID().getInt64();
            this.seller = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getOffer().getSellerID());
        }

        public Builder(String seller, Long offerId) {
            this.seller = seller;
            this.offerId = offerId;
        }

        public Builder setSourceAccount(@NonNull String sourceAccount) {
            if (sourceAccount == null) {
                throw new NullPointerException("sourceAccount is marked non-null but is null");
            }
            this.sourceAccount = sourceAccount;
            return this;
        }

        public RevokeOfferSponsorshipOperation build() {
            RevokeOfferSponsorshipOperation operation = new RevokeOfferSponsorshipOperation(this.seller, this.offerId);
            if (this.sourceAccount != null) {
                operation.setSourceAccount(this.sourceAccount);
            }
            return operation;
        }
    }
}

