/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.AccountMergeOperation;
import org.stellar.sdk.AccountRequiresMemoException;
import org.stellar.sdk.Asset;
import org.stellar.sdk.FeeBumpTransaction;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Network;
import org.stellar.sdk.NetworkMismatchException;
import org.stellar.sdk.Operation;
import org.stellar.sdk.PathPaymentStrictReceiveOperation;
import org.stellar.sdk.PathPaymentStrictSendOperation;
import org.stellar.sdk.PaymentOperation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.requests.AccountsRequestBuilder;
import org.stellar.sdk.requests.AssetsRequestBuilder;
import org.stellar.sdk.requests.ClaimableBalancesRequestBuilder;
import org.stellar.sdk.requests.ClientIdentificationInterceptor;
import org.stellar.sdk.requests.EffectsRequestBuilder;
import org.stellar.sdk.requests.ErrorResponse;
import org.stellar.sdk.requests.FeeStatsRequestBuilder;
import org.stellar.sdk.requests.LedgersRequestBuilder;
import org.stellar.sdk.requests.LiquidityPoolsRequestBuilder;
import org.stellar.sdk.requests.OffersRequestBuilder;
import org.stellar.sdk.requests.OperationsRequestBuilder;
import org.stellar.sdk.requests.OrderBookRequestBuilder;
import org.stellar.sdk.requests.PaymentsRequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.StrictReceivePathsRequestBuilder;
import org.stellar.sdk.requests.StrictSendPathsRequestBuilder;
import org.stellar.sdk.requests.TradeAggregationsRequestBuilder;
import org.stellar.sdk.requests.TradesRequestBuilder;
import org.stellar.sdk.requests.TransactionsRequestBuilder;
import org.stellar.sdk.responses.AccountResponse;
import org.stellar.sdk.responses.GsonSingleton;
import org.stellar.sdk.responses.RootResponse;
import org.stellar.sdk.responses.SubmitTransactionResponse;
import org.stellar.sdk.responses.SubmitTransactionTimeoutResponseException;
import org.stellar.sdk.responses.SubmitTransactionUnknownResponseException;
import org.stellar.sdk.xdr.CryptoKeyType;

public class Server
implements Closeable {
    private final HttpUrl serverURI;
    private OkHttpClient httpClient;
    private Optional<Network> network;
    private final ReentrantReadWriteLock networkLock;
    private OkHttpClient submitHttpClient;
    private static final int HORIZON_SUBMIT_TIMEOUT = 60;
    private static final String ACCOUNT_REQUIRES_MEMO_VALUE = "MQ==";
    private static final String ACCOUNT_REQUIRES_MEMO_KEY = "config.memo_required";

    public Server(String uri) {
        this(uri, new OkHttpClient.Builder().addInterceptor((Interceptor)new ClientIdentificationInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build(), new OkHttpClient.Builder().addInterceptor((Interceptor)new ClientIdentificationInterceptor()).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(65L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build());
    }

    public Server(String serverURI, OkHttpClient httpClient, OkHttpClient submitHttpClient) {
        this.serverURI = HttpUrl.parse((String)serverURI);
        this.httpClient = httpClient;
        this.submitHttpClient = submitHttpClient;
        this.network = Optional.empty();
        this.networkLock = new ReentrantReadWriteLock();
    }

    public RootResponse root() throws IOException {
        TypeToken<RootResponse> type = new TypeToken<RootResponse>(){};
        ResponseHandler<RootResponse> responseHandler = new ResponseHandler<RootResponse>(type);
        Request request = new Request.Builder().get().url(this.serverURI).build();
        Response response = this.httpClient.newCall(request).execute();
        RootResponse parsedResponse = responseHandler.handleResponse(response);
        this.setNetwork(new Network(parsedResponse.getNetworkPassphrase()));
        return parsedResponse;
    }

    public AccountsRequestBuilder accounts() {
        return new AccountsRequestBuilder(this.httpClient, this.serverURI);
    }

    public AssetsRequestBuilder assets() {
        return new AssetsRequestBuilder(this.httpClient, this.serverURI);
    }

    public ClaimableBalancesRequestBuilder claimableBalances() {
        return new ClaimableBalancesRequestBuilder(this.httpClient, this.serverURI);
    }

    public EffectsRequestBuilder effects() {
        return new EffectsRequestBuilder(this.httpClient, this.serverURI);
    }

    public LedgersRequestBuilder ledgers() {
        return new LedgersRequestBuilder(this.httpClient, this.serverURI);
    }

    public OffersRequestBuilder offers() {
        return new OffersRequestBuilder(this.httpClient, this.serverURI);
    }

    public OperationsRequestBuilder operations() {
        return new OperationsRequestBuilder(this.httpClient, this.serverURI);
    }

    public FeeStatsRequestBuilder feeStats() {
        return new FeeStatsRequestBuilder(this.httpClient, this.serverURI);
    }

    public OrderBookRequestBuilder orderBook() {
        return new OrderBookRequestBuilder(this.httpClient, this.serverURI);
    }

    public TradesRequestBuilder trades() {
        return new TradesRequestBuilder(this.httpClient, this.serverURI);
    }

    public TradeAggregationsRequestBuilder tradeAggregations(Asset baseAsset, Asset counterAsset, long startTime, long endTime, long resolution, long offset) {
        return new TradeAggregationsRequestBuilder(this.httpClient, this.serverURI, baseAsset, counterAsset, startTime, endTime, resolution, offset);
    }

    public StrictReceivePathsRequestBuilder strictReceivePaths() {
        return new StrictReceivePathsRequestBuilder(this.httpClient, this.serverURI);
    }

    public StrictSendPathsRequestBuilder strictSendPaths() {
        return new StrictSendPathsRequestBuilder(this.httpClient, this.serverURI);
    }

    public PaymentsRequestBuilder payments() {
        return new PaymentsRequestBuilder(this.httpClient, this.serverURI);
    }

    public TransactionsRequestBuilder transactions() {
        return new TransactionsRequestBuilder(this.httpClient, this.serverURI);
    }

    public LiquidityPoolsRequestBuilder liquidityPools() {
        return new LiquidityPoolsRequestBuilder(this.httpClient, this.serverURI);
    }

    private Optional<Network> getNetwork() {
        ReentrantReadWriteLock.ReadLock readLock = this.networkLock.readLock();
        readLock.lock();
        try {
            Optional<Network> optional = this.network;
            return optional;
        }
        finally {
            readLock.unlock();
        }
    }

    private void setNetwork(Network network) {
        ReentrantReadWriteLock.WriteLock writeLock = this.networkLock.writeLock();
        writeLock.lock();
        try {
            this.network = Optional.of(network);
        }
        finally {
            writeLock.unlock();
        }
    }

    private void checkTransactionNetwork(AbstractTransaction transaction) throws IOException {
        Optional<Network> network = this.getNetwork();
        if (!network.isPresent()) {
            this.root();
        }
        if (!(network = this.getNetwork()).get().equals(transaction.getNetwork())) {
            throw new NetworkMismatchException(network.get(), transaction.getNetwork());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SubmitTransactionResponse submitTransactionXdr(String transactionXdr) throws IOException {
        HttpUrl transactionsURI = this.serverURI.newBuilder().addPathSegment("transactions").build();
        FormBody requestBody = new FormBody.Builder().add("tx", transactionXdr).build();
        Request submitTransactionRequest = new Request.Builder().url(transactionsURI).post((RequestBody)requestBody).build();
        SubmitTransactionResponse submitTransactionResponse = null;
        try (Response response = null;){
            response = this.submitHttpClient.newCall(submitTransactionRequest).execute();
            switch (response.code()) {
                case 200: 
                case 400: {
                    submitTransactionResponse = (SubmitTransactionResponse)GsonSingleton.getInstance().fromJson(response.body().string(), SubmitTransactionResponse.class);
                    return submitTransactionResponse;
                }
                case 504: {
                    throw new SubmitTransactionTimeoutResponseException();
                }
                default: {
                    throw new SubmitTransactionUnknownResponseException(response.code(), response.body().string());
                }
            }
        }
    }

    public SubmitTransactionResponse submitTransaction(Transaction transaction, boolean skipMemoRequiredCheck) throws IOException, AccountRequiresMemoException {
        this.checkTransactionNetwork(transaction);
        if (!skipMemoRequiredCheck) {
            this.checkMemoRequired(transaction);
        }
        return this.submitTransactionXdr(transaction.toEnvelopeXdrBase64());
    }

    public SubmitTransactionResponse submitTransaction(FeeBumpTransaction transaction, boolean skipMemoRequiredCheck) throws IOException, AccountRequiresMemoException {
        this.checkTransactionNetwork(transaction);
        if (!skipMemoRequiredCheck) {
            this.checkMemoRequired(transaction.getInnerTransaction());
        }
        return this.submitTransactionXdr(transaction.toEnvelopeXdrBase64());
    }

    public SubmitTransactionResponse submitTransaction(Transaction transaction) throws IOException, AccountRequiresMemoException {
        return this.submitTransaction(transaction, false);
    }

    public SubmitTransactionResponse submitTransaction(FeeBumpTransaction transaction) throws IOException, AccountRequiresMemoException {
        return this.submitTransaction(transaction, false);
    }

    private boolean hashMemoId(String muxedAccount) {
        return StrKey.encodeToXDRMuxedAccount(muxedAccount).getDiscriminant() == CryptoKeyType.KEY_TYPE_MUXED_ED25519;
    }

    private void checkMemoRequired(Transaction transaction) throws IOException, AccountRequiresMemoException {
        if (transaction.getMemo() != null && !transaction.getMemo().equals(Memo.none())) {
            return;
        }
        HashSet<String> destinations = new HashSet<String>();
        Operation[] operations = transaction.getOperations();
        for (int i = 0; i < operations.length; ++i) {
            AccountResponse.Data data;
            String destination;
            Operation operation = operations[i];
            if (operation instanceof PaymentOperation) {
                destination = ((PaymentOperation)operation).getDestination();
            } else if (operation instanceof PathPaymentStrictReceiveOperation) {
                destination = ((PathPaymentStrictReceiveOperation)operation).getDestination();
            } else if (operation instanceof PathPaymentStrictSendOperation) {
                destination = ((PathPaymentStrictSendOperation)operation).getDestination();
            } else {
                if (!(operation instanceof AccountMergeOperation)) continue;
                destination = ((AccountMergeOperation)operation).getDestination();
            }
            if (destinations.contains(destination) || this.hashMemoId(destination)) continue;
            destinations.add(destination);
            try {
                data = this.accounts().account(destination).getData();
            }
            catch (ErrorResponse e) {
                if (e.getCode() == 404) continue;
                throw e;
            }
            if (!ACCOUNT_REQUIRES_MEMO_VALUE.equals(data.get(ACCOUNT_REQUIRES_MEMO_KEY))) continue;
            throw new AccountRequiresMemoException("Destination account requires a memo in the transaction.", destination, i);
        }
    }

    @Override
    public void close() {
        this.httpClient.connectionPool().evictAll();
        this.submitHttpClient.connectionPool().evictAll();
    }

    @Generated
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Generated
    public OkHttpClient getSubmitHttpClient() {
        return this.submitHttpClient;
    }

    @Generated
    public void setSubmitHttpClient(OkHttpClient submitHttpClient) {
        this.submitHttpClient = submitHttpClient;
    }
}

