/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.effects.EffectResponse;

public class EffectsRequestBuilder
extends RequestBuilder {
    public EffectsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "effects");
    }

    public EffectsRequestBuilder forAccount(@NonNull String account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.setSegments("accounts", account, "effects");
        return this;
    }

    public EffectsRequestBuilder forLedger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq), "effects");
        return this;
    }

    public EffectsRequestBuilder forTransaction(@NonNull String transactionId) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId is marked non-null but is null");
        }
        this.setSegments("transactions", transactionId, "effects");
        return this;
    }

    public EffectsRequestBuilder forLiquidityPool(LiquidityPoolID liquidityPoolID) {
        return this.forLiquidityPool(String.valueOf(liquidityPoolID));
    }

    public EffectsRequestBuilder forLiquidityPool(String liquidityPoolID) {
        this.setSegments("liquidity_pools", liquidityPoolID, "effects");
        return this;
    }

    public EffectsRequestBuilder forOperation(long operationId) {
        this.setSegments("operations", String.valueOf(operationId), "effects");
        return this;
    }

    public static Page<EffectResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<EffectResponse>> type = new TypeToken<Page<EffectResponse>>(){};
        ResponseHandler<Page<EffectResponse>> responseHandler = new ResponseHandler<Page<EffectResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public SSEStream<EffectResponse> stream(EventListener<EffectResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, EffectResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<EffectResponse> stream(EventListener<EffectResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<EffectResponse> execute() throws IOException, TooManyRequestsException {
        return EffectsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public EffectsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public EffectsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public EffectsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

