/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.PathResponse;

public class StrictReceivePathsRequestBuilder
extends RequestBuilder {
    public StrictReceivePathsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "");
        this.setSegments("paths", "strict-receive");
    }

    public StrictReceivePathsRequestBuilder destinationAccount(String account) {
        this.uriBuilder.setQueryParameter("destination_account", account);
        return this;
    }

    public StrictReceivePathsRequestBuilder sourceAccount(String account) {
        if (this.uriBuilder.build().queryParameter("source_assets") != null) {
            throw new RuntimeException("cannot set both source_assets and source_account");
        }
        this.uriBuilder.setQueryParameter("source_account", account);
        return this;
    }

    public StrictReceivePathsRequestBuilder sourceAssets(List<Asset> assets) {
        if (this.uriBuilder.build().queryParameter("source_account") != null) {
            throw new RuntimeException("cannot set both source_assets and source_account");
        }
        this.setAssetsParameter("source_assets", assets);
        return this;
    }

    public StrictReceivePathsRequestBuilder destinationAmount(String amount) {
        this.uriBuilder.setQueryParameter("destination_amount", amount);
        return this;
    }

    public StrictReceivePathsRequestBuilder destinationAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("destination_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("destination_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("destination_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public static Page<PathResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<PathResponse>> type = new TypeToken<Page<PathResponse>>(){};
        ResponseHandler<Page<PathResponse>> responseHandler = new ResponseHandler<Page<PathResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public Page<PathResponse> execute() throws IOException, TooManyRequestsException {
        return StrictReceivePathsRequestBuilder.execute(this.httpClient, this.buildUri());
    }
}

