/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.requests.TooManyRequestsException;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.TradeResponse;

public class TradesRequestBuilder
extends RequestBuilder {
    private static final String TRADE_TYPE_PARAMETER_NAME = "trade_type";

    public TradesRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "trades");
    }

    public TradesRequestBuilder baseAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("base_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("base_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("base_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public TradesRequestBuilder counterAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("counter_asset_type", asset.getType());
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("counter_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("counter_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public TradesRequestBuilder forAccount(@NonNull String account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.setSegments("accounts", account, "trades");
        return this;
    }

    public TradesRequestBuilder forLiquidityPool(LiquidityPoolID liquidityPoolID) {
        return this.forLiquidityPool(String.valueOf(liquidityPoolID));
    }

    public TradesRequestBuilder forLiquidityPool(String liquidityPoolID) {
        this.setSegments("liquidity_pools", String.valueOf(liquidityPoolID), "trades");
        return this;
    }

    public TradesRequestBuilder forTradeType(@NonNull String tradeType) {
        if (tradeType == null) {
            throw new NullPointerException("tradeType is marked non-null but is null");
        }
        this.uriBuilder.setQueryParameter(TRADE_TYPE_PARAMETER_NAME, tradeType);
        return this;
    }

    public static Page<TradeResponse> execute(OkHttpClient httpClient, HttpUrl uri) throws IOException, TooManyRequestsException {
        TypeToken<Page<TradeResponse>> type = new TypeToken<Page<TradeResponse>>(){};
        ResponseHandler<Page<TradeResponse>> responseHandler = new ResponseHandler<Page<TradeResponse>>(type);
        Request request = new Request.Builder().get().url(uri).build();
        Response response = httpClient.newCall(request).execute();
        return responseHandler.handleResponse(response);
    }

    public Page<TradeResponse> execute() throws IOException, TooManyRequestsException {
        return TradesRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    public TradesRequestBuilder offerId(Long offerId) {
        if (offerId == null) {
            this.uriBuilder.removeAllQueryParameters("offer_id");
            return this;
        }
        this.uriBuilder.setQueryParameter("offer_id", offerId.toString());
        return this;
    }

    @Override
    public TradesRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public TradesRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    public SSEStream<TradeResponse> stream(EventListener<TradeResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, TradeResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<TradeResponse> stream(EventListener<TradeResponse> listener) {
        return this.stream(listener, 15000L);
    }
}

