/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPoolID;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.xdr.LiquidityPoolType;

public final class LiquidityPoolResponse
extends Response {
    @SerializedName(value="id")
    private final LiquidityPoolID id;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="fee_bp")
    private final Integer feeBP;
    @SerializedName(value="type")
    private final LiquidityPoolType type;
    @SerializedName(value="total_trustlines")
    private final Long totalTrustlines;
    @SerializedName(value="total_shares")
    private final String totalShares;
    @SerializedName(value="reserves")
    private final Reserve[] reserves;
    @SerializedName(value="last_modified_ledger")
    private final Long lastModifiedLedger;
    @SerializedName(value="last_modified_time")
    private final String lastModifiedTime;
    @SerializedName(value="_links")
    private final Links links;

    public LiquidityPoolID getID() {
        return this.id;
    }

    @Generated
    public LiquidityPoolResponse(LiquidityPoolID id, String pagingToken, Integer feeBP, LiquidityPoolType type, Long totalTrustlines, String totalShares, Reserve[] reserves, Long lastModifiedLedger, String lastModifiedTime, Links links) {
        this.id = id;
        this.pagingToken = pagingToken;
        this.feeBP = feeBP;
        this.type = type;
        this.totalTrustlines = totalTrustlines;
        this.totalShares = totalShares;
        this.reserves = reserves;
        this.lastModifiedLedger = lastModifiedLedger;
        this.lastModifiedTime = lastModifiedTime;
        this.links = links;
    }

    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public Integer getFeeBP() {
        return this.feeBP;
    }

    @Generated
    public LiquidityPoolType getType() {
        return this.type;
    }

    @Generated
    public Long getTotalTrustlines() {
        return this.totalTrustlines;
    }

    @Generated
    public String getTotalShares() {
        return this.totalShares;
    }

    @Generated
    public Reserve[] getReserves() {
        return this.reserves;
    }

    @Generated
    public Long getLastModifiedLedger() {
        return this.lastModifiedLedger;
    }

    @Generated
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "LiquidityPoolResponse(id=" + this.getID() + ", pagingToken=" + this.getPagingToken() + ", feeBP=" + this.getFeeBP() + ", type=" + this.getType() + ", totalTrustlines=" + this.getTotalTrustlines() + ", totalShares=" + this.getTotalShares() + ", reserves=" + Arrays.deepToString(this.getReserves()) + ", lastModifiedLedger=" + this.getLastModifiedLedger() + ", lastModifiedTime=" + this.getLastModifiedTime() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolResponse)) {
            return false;
        }
        LiquidityPoolResponse other = (LiquidityPoolResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$feeBP = this.getFeeBP();
        Integer other$feeBP = other.getFeeBP();
        if (this$feeBP == null ? other$feeBP != null : !((Object)this$feeBP).equals(other$feeBP)) {
            return false;
        }
        Long this$totalTrustlines = this.getTotalTrustlines();
        Long other$totalTrustlines = other.getTotalTrustlines();
        if (this$totalTrustlines == null ? other$totalTrustlines != null : !((Object)this$totalTrustlines).equals(other$totalTrustlines)) {
            return false;
        }
        Long this$lastModifiedLedger = this.getLastModifiedLedger();
        Long other$lastModifiedLedger = other.getLastModifiedLedger();
        if (this$lastModifiedLedger == null ? other$lastModifiedLedger != null : !((Object)this$lastModifiedLedger).equals(other$lastModifiedLedger)) {
            return false;
        }
        LiquidityPoolID this$id = this.getID();
        LiquidityPoolID other$id = other.getID();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        LiquidityPoolType this$type = this.getType();
        LiquidityPoolType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$totalShares = this.getTotalShares();
        String other$totalShares = other.getTotalShares();
        if (this$totalShares == null ? other$totalShares != null : !this$totalShares.equals(other$totalShares)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getReserves(), other.getReserves())) {
            return false;
        }
        String this$lastModifiedTime = this.getLastModifiedTime();
        String other$lastModifiedTime = other.getLastModifiedTime();
        if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !this$lastModifiedTime.equals(other$lastModifiedTime)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $feeBP = this.getFeeBP();
        result = result * 59 + ($feeBP == null ? 43 : ((Object)$feeBP).hashCode());
        Long $totalTrustlines = this.getTotalTrustlines();
        result = result * 59 + ($totalTrustlines == null ? 43 : ((Object)$totalTrustlines).hashCode());
        Long $lastModifiedLedger = this.getLastModifiedLedger();
        result = result * 59 + ($lastModifiedLedger == null ? 43 : ((Object)$lastModifiedLedger).hashCode());
        LiquidityPoolID $id = this.getID();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        LiquidityPoolType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $totalShares = this.getTotalShares();
        result = result * 59 + ($totalShares == null ? 43 : $totalShares.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getReserves());
        String $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : $lastModifiedTime.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Reserve {
        @SerializedName(value="amount")
        private final String amount;
        @SerializedName(value="asset")
        private final Asset asset;

        public Reserve(@NonNull String amount, @NonNull String asset) {
            this(amount, Asset.create(asset));
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
        }

        @Generated
        public String getAmount() {
            return this.amount;
        }

        @Generated
        public Asset getAsset() {
            return this.asset;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reserve)) {
                return false;
            }
            Reserve other = (Reserve)o;
            String this$amount = this.getAmount();
            String other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
                return false;
            }
            Asset this$asset = this.getAsset();
            Asset other$asset = other.getAsset();
            return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
            Asset $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LiquidityPoolResponse.Reserve(amount=" + this.getAmount() + ", asset=" + this.getAsset() + ")";
        }

        @Generated
        public Reserve(String amount, Asset asset) {
            this.amount = amount;
            this.asset = asset;
        }
    }

    public static final class Links {
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="transactions")
        private final Link transactions;

        @Generated
        public Links(Link self, Link operations, Link transactions) {
            this.self = self;
            this.operations = operations;
            this.transactions = transactions;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public Link getOperations() {
            return this.operations;
        }

        @Generated
        public Link getTransactions() {
            return this.transactions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
                return false;
            }
            Link this$operations = this.getOperations();
            Link other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Link this$transactions = this.getTransactions();
            Link other$transactions = other.getTransactions();
            return !(this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            Link $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Link $transactions = this.getTransactions();
            result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LiquidityPoolResponse.Links(self=" + this.getSelf() + ", operations=" + this.getOperations() + ", transactions=" + this.getTransactions() + ")";
        }
    }
}

