/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.effects;

import com.google.gson.annotations.SerializedName;
import lombok.Generated;
import org.stellar.sdk.Asset;
import org.stellar.sdk.responses.effects.EffectResponse;

public final class TrustlineFlagsUpdatedEffectResponse
extends EffectResponse {
    @SerializedName(value="trustor")
    private final String trustor;
    @SerializedName(value="asset_type")
    private final String assetType;
    @SerializedName(value="asset_code")
    private final String assetCode;
    @SerializedName(value="asset_issuer")
    private final String assetIssuer;
    @SerializedName(value="authorized_flag")
    private final boolean authorized;
    @SerializedName(value="authorized_to_maintain_liabilites_flag")
    private final boolean authorizedToMaintainLiabilities;
    @SerializedName(value="clawback_enabled_flag")
    private final boolean clawbackEnabled;

    public Asset getAsset() {
        return Asset.create(this.assetType, this.assetCode, this.assetIssuer);
    }

    public boolean getAuthorized() {
        return this.authorized;
    }

    public boolean getAuthorizedToMaintainLiabilities() {
        return this.authorizedToMaintainLiabilities;
    }

    public boolean getClawbackEnabled() {
        return this.clawbackEnabled;
    }

    @Generated
    public TrustlineFlagsUpdatedEffectResponse(String trustor, String assetType, String assetCode, String assetIssuer, boolean authorized, boolean authorizedToMaintainLiabilities, boolean clawbackEnabled) {
        this.trustor = trustor;
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.authorized = authorized;
        this.authorizedToMaintainLiabilities = authorizedToMaintainLiabilities;
        this.clawbackEnabled = clawbackEnabled;
    }

    @Generated
    public String getTrustor() {
        return this.trustor;
    }

    @Generated
    public String getAssetType() {
        return this.assetType;
    }

    @Generated
    public String getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public String getAssetIssuer() {
        return this.assetIssuer;
    }

    @Generated
    public String toString() {
        return "TrustlineFlagsUpdatedEffectResponse(trustor=" + this.getTrustor() + ", assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", authorized=" + this.getAuthorized() + ", authorizedToMaintainLiabilities=" + this.getAuthorizedToMaintainLiabilities() + ", clawbackEnabled=" + this.getClawbackEnabled() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustlineFlagsUpdatedEffectResponse)) {
            return false;
        }
        TrustlineFlagsUpdatedEffectResponse other = (TrustlineFlagsUpdatedEffectResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAuthorized() != other.getAuthorized()) {
            return false;
        }
        if (this.getAuthorizedToMaintainLiabilities() != other.getAuthorizedToMaintainLiabilities()) {
            return false;
        }
        if (this.getClawbackEnabled() != other.getClawbackEnabled()) {
            return false;
        }
        String this$trustor = this.getTrustor();
        String other$trustor = other.getTrustor();
        if (this$trustor == null ? other$trustor != null : !this$trustor.equals(other$trustor)) {
            return false;
        }
        String this$assetType = this.getAssetType();
        String other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        String this$assetCode = this.getAssetCode();
        String other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
            return false;
        }
        String this$assetIssuer = this.getAssetIssuer();
        String other$assetIssuer = other.getAssetIssuer();
        return !(this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrustlineFlagsUpdatedEffectResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.getAuthorized() ? 79 : 97);
        result = result * 59 + (this.getAuthorizedToMaintainLiabilities() ? 79 : 97);
        result = result * 59 + (this.getClawbackEnabled() ? 79 : 97);
        String $trustor = this.getTrustor();
        result = result * 59 + ($trustor == null ? 43 : $trustor.hashCode());
        String $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        String $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
        String $assetIssuer = this.getAssetIssuer();
        result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
        return result;
    }
}

