/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountMergeResultCode;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AccountMergeResult
implements XdrElement {
    AccountMergeResultCode code;
    private Int64 sourceAccountBalance;

    public AccountMergeResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(AccountMergeResultCode value) {
        this.code = value;
    }

    public Int64 getSourceAccountBalance() {
        return this.sourceAccountBalance;
    }

    public void setSourceAccountBalance(Int64 value) {
        this.sourceAccountBalance = value;
    }

    public static void encode(XdrDataOutputStream stream, AccountMergeResult encodedAccountMergeResult) throws IOException {
        stream.writeInt(encodedAccountMergeResult.getDiscriminant().getValue());
        switch (encodedAccountMergeResult.getDiscriminant()) {
            case ACCOUNT_MERGE_SUCCESS: {
                Int64.encode(stream, encodedAccountMergeResult.sourceAccountBalance);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountMergeResult.encode(stream, this);
    }

    public static AccountMergeResult decode(XdrDataInputStream stream) throws IOException {
        AccountMergeResult decodedAccountMergeResult = new AccountMergeResult();
        AccountMergeResultCode discriminant = AccountMergeResultCode.decode(stream);
        decodedAccountMergeResult.setDiscriminant(discriminant);
        switch (decodedAccountMergeResult.getDiscriminant()) {
            case ACCOUNT_MERGE_SUCCESS: {
                decodedAccountMergeResult.sourceAccountBalance = Int64.decode(stream);
                break;
            }
        }
        return decodedAccountMergeResult;
    }

    public int hashCode() {
        return Objects.hash(this.sourceAccountBalance, this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountMergeResult)) {
            return false;
        }
        AccountMergeResult other = (AccountMergeResult)object;
        return Objects.equals(this.sourceAccountBalance, other.sourceAccountBalance) && Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AccountMergeResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountMergeResult.fromXdrByteArray(bytes);
    }

    public static AccountMergeResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountMergeResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AccountMergeResultCode discriminant;
        private Int64 sourceAccountBalance;

        public Builder discriminant(AccountMergeResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder sourceAccountBalance(Int64 sourceAccountBalance) {
            this.sourceAccountBalance = sourceAccountBalance;
            return this;
        }

        public AccountMergeResult build() {
            AccountMergeResult val = new AccountMergeResult();
            val.setDiscriminant(this.discriminant);
            val.setSourceAccountBalance(this.sourceAccountBalance);
            return val;
        }
    }
}

