/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AllowTrustResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AllowTrustResult
implements XdrElement {
    AllowTrustResultCode code;

    public AllowTrustResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(AllowTrustResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, AllowTrustResult encodedAllowTrustResult) throws IOException {
        stream.writeInt(encodedAllowTrustResult.getDiscriminant().getValue());
        switch (encodedAllowTrustResult.getDiscriminant()) {
            case ALLOW_TRUST_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AllowTrustResult.encode(stream, this);
    }

    public static AllowTrustResult decode(XdrDataInputStream stream) throws IOException {
        AllowTrustResult decodedAllowTrustResult = new AllowTrustResult();
        AllowTrustResultCode discriminant = AllowTrustResultCode.decode(stream);
        decodedAllowTrustResult.setDiscriminant(discriminant);
        switch (decodedAllowTrustResult.getDiscriminant()) {
            case ALLOW_TRUST_SUCCESS: {
                break;
            }
        }
        return decodedAllowTrustResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AllowTrustResult)) {
            return false;
        }
        AllowTrustResult other = (AllowTrustResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static AllowTrustResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AllowTrustResult.fromXdrByteArray(bytes);
    }

    public static AllowTrustResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AllowTrustResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AllowTrustResultCode discriminant;

        public Builder discriminant(AllowTrustResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public AllowTrustResult build() {
            AllowTrustResult val = new AllowTrustResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

