/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class BumpSequenceOp
implements XdrElement {
    private SequenceNumber bumpTo;

    public SequenceNumber getBumpTo() {
        return this.bumpTo;
    }

    public void setBumpTo(SequenceNumber value) {
        this.bumpTo = value;
    }

    public static void encode(XdrDataOutputStream stream, BumpSequenceOp encodedBumpSequenceOp) throws IOException {
        SequenceNumber.encode(stream, encodedBumpSequenceOp.bumpTo);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        BumpSequenceOp.encode(stream, this);
    }

    public static BumpSequenceOp decode(XdrDataInputStream stream) throws IOException {
        BumpSequenceOp decodedBumpSequenceOp = new BumpSequenceOp();
        decodedBumpSequenceOp.bumpTo = SequenceNumber.decode(stream);
        return decodedBumpSequenceOp;
    }

    public int hashCode() {
        return Objects.hash(this.bumpTo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BumpSequenceOp)) {
            return false;
        }
        BumpSequenceOp other = (BumpSequenceOp)object;
        return Objects.equals(this.bumpTo, other.bumpTo);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static BumpSequenceOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BumpSequenceOp.fromXdrByteArray(bytes);
    }

    public static BumpSequenceOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BumpSequenceOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SequenceNumber bumpTo;

        public Builder bumpTo(SequenceNumber bumpTo) {
            this.bumpTo = bumpTo;
            return this;
        }

        public BumpSequenceOp build() {
            BumpSequenceOp val = new BumpSequenceOp();
            val.setBumpTo(this.bumpTo);
            return val;
        }
    }
}

