/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ConfigSettingEntry;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ConfigUpgradeSet
implements XdrElement {
    private ConfigSettingEntry[] updatedEntry;

    public ConfigSettingEntry[] getUpdatedEntry() {
        return this.updatedEntry;
    }

    public void setUpdatedEntry(ConfigSettingEntry[] value) {
        this.updatedEntry = value;
    }

    public static void encode(XdrDataOutputStream stream, ConfigUpgradeSet encodedConfigUpgradeSet) throws IOException {
        int updatedEntrysize = encodedConfigUpgradeSet.getUpdatedEntry().length;
        stream.writeInt(updatedEntrysize);
        for (int i = 0; i < updatedEntrysize; ++i) {
            ConfigSettingEntry.encode(stream, encodedConfigUpgradeSet.updatedEntry[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ConfigUpgradeSet.encode(stream, this);
    }

    public static ConfigUpgradeSet decode(XdrDataInputStream stream) throws IOException {
        ConfigUpgradeSet decodedConfigUpgradeSet = new ConfigUpgradeSet();
        int updatedEntrysize = stream.readInt();
        decodedConfigUpgradeSet.updatedEntry = new ConfigSettingEntry[updatedEntrysize];
        for (int i = 0; i < updatedEntrysize; ++i) {
            decodedConfigUpgradeSet.updatedEntry[i] = ConfigSettingEntry.decode(stream);
        }
        return decodedConfigUpgradeSet;
    }

    public int hashCode() {
        return Arrays.hashCode(this.updatedEntry);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConfigUpgradeSet)) {
            return false;
        }
        ConfigUpgradeSet other = (ConfigUpgradeSet)object;
        return Arrays.equals(this.updatedEntry, other.updatedEntry);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ConfigUpgradeSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ConfigUpgradeSet.fromXdrByteArray(bytes);
    }

    public static ConfigUpgradeSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ConfigUpgradeSet.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ConfigSettingEntry[] updatedEntry;

        public Builder updatedEntry(ConfigSettingEntry[] updatedEntry) {
            this.updatedEntry = updatedEntry;
            return this;
        }

        public ConfigUpgradeSet build() {
            ConfigUpgradeSet val = new ConfigUpgradeSet();
            val.setUpdatedEntry(this.updatedEntry);
            return val;
        }
    }
}

