/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.CreateAccountResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class CreateAccountResult
implements XdrElement {
    CreateAccountResultCode code;

    public CreateAccountResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(CreateAccountResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, CreateAccountResult encodedCreateAccountResult) throws IOException {
        stream.writeInt(encodedCreateAccountResult.getDiscriminant().getValue());
        switch (encodedCreateAccountResult.getDiscriminant()) {
            case CREATE_ACCOUNT_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CreateAccountResult.encode(stream, this);
    }

    public static CreateAccountResult decode(XdrDataInputStream stream) throws IOException {
        CreateAccountResult decodedCreateAccountResult = new CreateAccountResult();
        CreateAccountResultCode discriminant = CreateAccountResultCode.decode(stream);
        decodedCreateAccountResult.setDiscriminant(discriminant);
        switch (decodedCreateAccountResult.getDiscriminant()) {
            case CREATE_ACCOUNT_SUCCESS: {
                break;
            }
        }
        return decodedCreateAccountResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CreateAccountResult)) {
            return false;
        }
        CreateAccountResult other = (CreateAccountResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static CreateAccountResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateAccountResult.fromXdrByteArray(bytes);
    }

    public static CreateAccountResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateAccountResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private CreateAccountResultCode discriminant;

        public Builder discriminant(CreateAccountResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public CreateAccountResult build() {
            CreateAccountResult val = new CreateAccountResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

