/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ExtendFootprintTTLOp
implements XdrElement {
    private ExtensionPoint ext;
    private Uint32 extendTo;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public Uint32 getExtendTo() {
        return this.extendTo;
    }

    public void setExtendTo(Uint32 value) {
        this.extendTo = value;
    }

    public static void encode(XdrDataOutputStream stream, ExtendFootprintTTLOp encodedExtendFootprintTTLOp) throws IOException {
        ExtensionPoint.encode(stream, encodedExtendFootprintTTLOp.ext);
        Uint32.encode(stream, encodedExtendFootprintTTLOp.extendTo);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ExtendFootprintTTLOp.encode(stream, this);
    }

    public static ExtendFootprintTTLOp decode(XdrDataInputStream stream) throws IOException {
        ExtendFootprintTTLOp decodedExtendFootprintTTLOp = new ExtendFootprintTTLOp();
        decodedExtendFootprintTTLOp.ext = ExtensionPoint.decode(stream);
        decodedExtendFootprintTTLOp.extendTo = Uint32.decode(stream);
        return decodedExtendFootprintTTLOp;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.extendTo);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtendFootprintTTLOp)) {
            return false;
        }
        ExtendFootprintTTLOp other = (ExtendFootprintTTLOp)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.extendTo, other.extendTo);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ExtendFootprintTTLOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ExtendFootprintTTLOp.fromXdrByteArray(bytes);
    }

    public static ExtendFootprintTTLOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ExtendFootprintTTLOp.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private Uint32 extendTo;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder extendTo(Uint32 extendTo) {
            this.extendTo = extendTo;
            return this;
        }

        public ExtendFootprintTTLOp build() {
            ExtendFootprintTTLOp val = new ExtendFootprintTTLOp();
            val.setExt(this.ext);
            val.setExtendTo(this.extendTo);
            return val;
        }
    }
}

