/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.InvokeHostFunctionResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InvokeHostFunctionResult
implements XdrElement {
    InvokeHostFunctionResultCode code;
    private Hash success;

    public InvokeHostFunctionResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(InvokeHostFunctionResultCode value) {
        this.code = value;
    }

    public Hash getSuccess() {
        return this.success;
    }

    public void setSuccess(Hash value) {
        this.success = value;
    }

    public static void encode(XdrDataOutputStream stream, InvokeHostFunctionResult encodedInvokeHostFunctionResult) throws IOException {
        stream.writeInt(encodedInvokeHostFunctionResult.getDiscriminant().getValue());
        switch (encodedInvokeHostFunctionResult.getDiscriminant()) {
            case INVOKE_HOST_FUNCTION_SUCCESS: {
                Hash.encode(stream, encodedInvokeHostFunctionResult.success);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        InvokeHostFunctionResult.encode(stream, this);
    }

    public static InvokeHostFunctionResult decode(XdrDataInputStream stream) throws IOException {
        InvokeHostFunctionResult decodedInvokeHostFunctionResult = new InvokeHostFunctionResult();
        InvokeHostFunctionResultCode discriminant = InvokeHostFunctionResultCode.decode(stream);
        decodedInvokeHostFunctionResult.setDiscriminant(discriminant);
        switch (decodedInvokeHostFunctionResult.getDiscriminant()) {
            case INVOKE_HOST_FUNCTION_SUCCESS: {
                decodedInvokeHostFunctionResult.success = Hash.decode(stream);
                break;
            }
        }
        return decodedInvokeHostFunctionResult;
    }

    public int hashCode() {
        return Objects.hash(this.success, this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof InvokeHostFunctionResult)) {
            return false;
        }
        InvokeHostFunctionResult other = (InvokeHostFunctionResult)object;
        return Objects.equals(this.success, other.success) && Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static InvokeHostFunctionResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InvokeHostFunctionResult.fromXdrByteArray(bytes);
    }

    public static InvokeHostFunctionResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InvokeHostFunctionResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private InvokeHostFunctionResultCode discriminant;
        private Hash success;

        public Builder discriminant(InvokeHostFunctionResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder success(Hash success) {
            this.success = success;
            return this;
        }

        public InvokeHostFunctionResult build() {
            InvokeHostFunctionResult val = new InvokeHostFunctionResult();
            val.setDiscriminant(this.discriminant);
            val.setSuccess(this.success);
            return val;
        }
    }
}

