/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum LedgerEntryChangeType implements XdrElement
{
    LEDGER_ENTRY_CREATED(0),
    LEDGER_ENTRY_UPDATED(1),
    LEDGER_ENTRY_REMOVED(2),
    LEDGER_ENTRY_STATE(3);

    private int mValue;

    private LedgerEntryChangeType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static LedgerEntryChangeType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return LEDGER_ENTRY_CREATED;
            }
            case 1: {
                return LEDGER_ENTRY_UPDATED;
            }
            case 2: {
                return LEDGER_ENTRY_REMOVED;
            }
            case 3: {
                return LEDGER_ENTRY_STATE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, LedgerEntryChangeType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerEntryChangeType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerEntryChangeType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerEntryChangeType.fromXdrByteArray(bytes);
    }

    public static LedgerEntryChangeType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerEntryChangeType.decode(xdrDataInputStream);
    }
}

