/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerFootprint
implements XdrElement {
    private LedgerKey[] readOnly;
    private LedgerKey[] readWrite;

    public LedgerKey[] getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(LedgerKey[] value) {
        this.readOnly = value;
    }

    public LedgerKey[] getReadWrite() {
        return this.readWrite;
    }

    public void setReadWrite(LedgerKey[] value) {
        this.readWrite = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerFootprint encodedLedgerFootprint) throws IOException {
        int readOnlysize = encodedLedgerFootprint.getReadOnly().length;
        stream.writeInt(readOnlysize);
        for (int i = 0; i < readOnlysize; ++i) {
            LedgerKey.encode(stream, encodedLedgerFootprint.readOnly[i]);
        }
        int readWritesize = encodedLedgerFootprint.getReadWrite().length;
        stream.writeInt(readWritesize);
        for (int i = 0; i < readWritesize; ++i) {
            LedgerKey.encode(stream, encodedLedgerFootprint.readWrite[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerFootprint.encode(stream, this);
    }

    public static LedgerFootprint decode(XdrDataInputStream stream) throws IOException {
        LedgerFootprint decodedLedgerFootprint = new LedgerFootprint();
        int readOnlysize = stream.readInt();
        decodedLedgerFootprint.readOnly = new LedgerKey[readOnlysize];
        for (int i = 0; i < readOnlysize; ++i) {
            decodedLedgerFootprint.readOnly[i] = LedgerKey.decode(stream);
        }
        int readWritesize = stream.readInt();
        decodedLedgerFootprint.readWrite = new LedgerKey[readWritesize];
        for (int i = 0; i < readWritesize; ++i) {
            decodedLedgerFootprint.readWrite[i] = LedgerKey.decode(stream);
        }
        return decodedLedgerFootprint;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.readOnly), Arrays.hashCode(this.readWrite));
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerFootprint)) {
            return false;
        }
        LedgerFootprint other = (LedgerFootprint)object;
        return Arrays.equals(this.readOnly, other.readOnly) && Arrays.equals(this.readWrite, other.readWrite);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerFootprint fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerFootprint.fromXdrByteArray(bytes);
    }

    public static LedgerFootprint fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerFootprint.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LedgerKey[] readOnly;
        private LedgerKey[] readWrite;

        public Builder readOnly(LedgerKey[] readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder readWrite(LedgerKey[] readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        public LedgerFootprint build() {
            LedgerFootprint val = new LedgerFootprint();
            val.setReadOnly(this.readOnly);
            val.setReadWrite(this.readWrite);
            return val;
        }
    }
}

