/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LedgerHeader;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerHeaderHistoryEntry
implements XdrElement {
    private Hash hash;
    private LedgerHeader header;
    private LedgerHeaderHistoryEntryExt ext;

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash value) {
        this.hash = value;
    }

    public LedgerHeader getHeader() {
        return this.header;
    }

    public void setHeader(LedgerHeader value) {
        this.header = value;
    }

    public LedgerHeaderHistoryEntryExt getExt() {
        return this.ext;
    }

    public void setExt(LedgerHeaderHistoryEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerHeaderHistoryEntry encodedLedgerHeaderHistoryEntry) throws IOException {
        Hash.encode(stream, encodedLedgerHeaderHistoryEntry.hash);
        LedgerHeader.encode(stream, encodedLedgerHeaderHistoryEntry.header);
        LedgerHeaderHistoryEntryExt.encode(stream, encodedLedgerHeaderHistoryEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerHeaderHistoryEntry.encode(stream, this);
    }

    public static LedgerHeaderHistoryEntry decode(XdrDataInputStream stream) throws IOException {
        LedgerHeaderHistoryEntry decodedLedgerHeaderHistoryEntry = new LedgerHeaderHistoryEntry();
        decodedLedgerHeaderHistoryEntry.hash = Hash.decode(stream);
        decodedLedgerHeaderHistoryEntry.header = LedgerHeader.decode(stream);
        decodedLedgerHeaderHistoryEntry.ext = LedgerHeaderHistoryEntryExt.decode(stream);
        return decodedLedgerHeaderHistoryEntry;
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.header, this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LedgerHeaderHistoryEntry)) {
            return false;
        }
        LedgerHeaderHistoryEntry other = (LedgerHeaderHistoryEntry)object;
        return Objects.equals(this.hash, other.hash) && Objects.equals(this.header, other.header) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LedgerHeaderHistoryEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerHeaderHistoryEntry.fromXdrByteArray(bytes);
    }

    public static LedgerHeaderHistoryEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerHeaderHistoryEntry.decode(xdrDataInputStream);
    }

    public static class LedgerHeaderHistoryEntryExt
    implements XdrElement {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerHeaderHistoryEntryExt encodedLedgerHeaderHistoryEntryExt) throws IOException {
            stream.writeInt(encodedLedgerHeaderHistoryEntryExt.getDiscriminant());
            switch (encodedLedgerHeaderHistoryEntryExt.getDiscriminant()) {
                default: 
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerHeaderHistoryEntryExt.encode(stream, this);
        }

        public static LedgerHeaderHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
            LedgerHeaderHistoryEntryExt decodedLedgerHeaderHistoryEntryExt = new LedgerHeaderHistoryEntryExt();
            Integer discriminant = stream.readInt();
            decodedLedgerHeaderHistoryEntryExt.setDiscriminant(discriminant);
            switch (decodedLedgerHeaderHistoryEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedLedgerHeaderHistoryEntryExt;
        }

        public int hashCode() {
            return Objects.hash(this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LedgerHeaderHistoryEntryExt)) {
                return false;
            }
            LedgerHeaderHistoryEntryExt other = (LedgerHeaderHistoryEntryExt)object;
            return Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LedgerHeaderHistoryEntryExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LedgerHeaderHistoryEntryExt.fromXdrByteArray(bytes);
        }

        public static LedgerHeaderHistoryEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LedgerHeaderHistoryEntryExt.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public LedgerHeaderHistoryEntryExt build() {
                LedgerHeaderHistoryEntryExt val = new LedgerHeaderHistoryEntryExt();
                val.setDiscriminant(this.discriminant);
                return val;
            }
        }
    }

    public static final class Builder {
        private Hash hash;
        private LedgerHeader header;
        private LedgerHeaderHistoryEntryExt ext;

        public Builder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        public Builder header(LedgerHeader header) {
            this.header = header;
            return this;
        }

        public Builder ext(LedgerHeaderHistoryEntryExt ext) {
            this.ext = ext;
            return this;
        }

        public LedgerHeaderHistoryEntry build() {
            LedgerHeaderHistoryEntry val = new LedgerHeaderHistoryEntry();
            val.setHash(this.hash);
            val.setHeader(this.header);
            val.setExt(this.ext);
            return val;
        }
    }
}

