/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LiquidityPoolDepositResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LiquidityPoolDepositResult
implements XdrElement {
    LiquidityPoolDepositResultCode code;

    public LiquidityPoolDepositResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(LiquidityPoolDepositResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, LiquidityPoolDepositResult encodedLiquidityPoolDepositResult) throws IOException {
        stream.writeInt(encodedLiquidityPoolDepositResult.getDiscriminant().getValue());
        switch (encodedLiquidityPoolDepositResult.getDiscriminant()) {
            case LIQUIDITY_POOL_DEPOSIT_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LiquidityPoolDepositResult.encode(stream, this);
    }

    public static LiquidityPoolDepositResult decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolDepositResult decodedLiquidityPoolDepositResult = new LiquidityPoolDepositResult();
        LiquidityPoolDepositResultCode discriminant = LiquidityPoolDepositResultCode.decode(stream);
        decodedLiquidityPoolDepositResult.setDiscriminant(discriminant);
        switch (decodedLiquidityPoolDepositResult.getDiscriminant()) {
            case LIQUIDITY_POOL_DEPOSIT_SUCCESS: {
                break;
            }
        }
        return decodedLiquidityPoolDepositResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolDepositResult)) {
            return false;
        }
        LiquidityPoolDepositResult other = (LiquidityPoolDepositResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LiquidityPoolDepositResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolDepositResult.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolDepositResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolDepositResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LiquidityPoolDepositResultCode discriminant;

        public Builder discriminant(LiquidityPoolDepositResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public LiquidityPoolDepositResult build() {
            LiquidityPoolDepositResult val = new LiquidityPoolDepositResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

