/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LiquidityPoolEntry
implements XdrElement {
    private PoolID liquidityPoolID;
    private LiquidityPoolEntryBody body;

    public PoolID getLiquidityPoolID() {
        return this.liquidityPoolID;
    }

    public void setLiquidityPoolID(PoolID value) {
        this.liquidityPoolID = value;
    }

    public LiquidityPoolEntryBody getBody() {
        return this.body;
    }

    public void setBody(LiquidityPoolEntryBody value) {
        this.body = value;
    }

    public static void encode(XdrDataOutputStream stream, LiquidityPoolEntry encodedLiquidityPoolEntry) throws IOException {
        PoolID.encode(stream, encodedLiquidityPoolEntry.liquidityPoolID);
        LiquidityPoolEntryBody.encode(stream, encodedLiquidityPoolEntry.body);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LiquidityPoolEntry.encode(stream, this);
    }

    public static LiquidityPoolEntry decode(XdrDataInputStream stream) throws IOException {
        LiquidityPoolEntry decodedLiquidityPoolEntry = new LiquidityPoolEntry();
        decodedLiquidityPoolEntry.liquidityPoolID = PoolID.decode(stream);
        decodedLiquidityPoolEntry.body = LiquidityPoolEntryBody.decode(stream);
        return decodedLiquidityPoolEntry;
    }

    public int hashCode() {
        return Objects.hash(this.liquidityPoolID, this.body);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LiquidityPoolEntry)) {
            return false;
        }
        LiquidityPoolEntry other = (LiquidityPoolEntry)object;
        return Objects.equals(this.liquidityPoolID, other.liquidityPoolID) && Objects.equals(this.body, other.body);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static LiquidityPoolEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LiquidityPoolEntry.fromXdrByteArray(bytes);
    }

    public static LiquidityPoolEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LiquidityPoolEntry.decode(xdrDataInputStream);
    }

    public static class LiquidityPoolEntryBody
    implements XdrElement {
        LiquidityPoolType type;
        private LiquidityPoolEntryConstantProduct constantProduct;

        public LiquidityPoolType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(LiquidityPoolType value) {
            this.type = value;
        }

        public LiquidityPoolEntryConstantProduct getConstantProduct() {
            return this.constantProduct;
        }

        public void setConstantProduct(LiquidityPoolEntryConstantProduct value) {
            this.constantProduct = value;
        }

        public static void encode(XdrDataOutputStream stream, LiquidityPoolEntryBody encodedLiquidityPoolEntryBody) throws IOException {
            stream.writeInt(encodedLiquidityPoolEntryBody.getDiscriminant().getValue());
            switch (encodedLiquidityPoolEntryBody.getDiscriminant()) {
                case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                    LiquidityPoolEntryConstantProduct.encode(stream, encodedLiquidityPoolEntryBody.constantProduct);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            LiquidityPoolEntryBody.encode(stream, this);
        }

        public static LiquidityPoolEntryBody decode(XdrDataInputStream stream) throws IOException {
            LiquidityPoolEntryBody decodedLiquidityPoolEntryBody = new LiquidityPoolEntryBody();
            LiquidityPoolType discriminant = LiquidityPoolType.decode(stream);
            decodedLiquidityPoolEntryBody.setDiscriminant(discriminant);
            switch (decodedLiquidityPoolEntryBody.getDiscriminant()) {
                case LIQUIDITY_POOL_CONSTANT_PRODUCT: {
                    decodedLiquidityPoolEntryBody.constantProduct = LiquidityPoolEntryConstantProduct.decode(stream);
                }
            }
            return decodedLiquidityPoolEntryBody;
        }

        public int hashCode() {
            return Objects.hash(this.constantProduct, this.type);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LiquidityPoolEntryBody)) {
                return false;
            }
            LiquidityPoolEntryBody other = (LiquidityPoolEntryBody)object;
            return Objects.equals(this.constantProduct, other.constantProduct) && Objects.equals(this.type, other.type);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static LiquidityPoolEntryBody fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return LiquidityPoolEntryBody.fromXdrByteArray(bytes);
        }

        public static LiquidityPoolEntryBody fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return LiquidityPoolEntryBody.decode(xdrDataInputStream);
        }

        public static class LiquidityPoolEntryConstantProduct
        implements XdrElement {
            private LiquidityPoolConstantProductParameters params;
            private Int64 reserveA;
            private Int64 reserveB;
            private Int64 totalPoolShares;
            private Int64 poolSharesTrustLineCount;

            public LiquidityPoolConstantProductParameters getParams() {
                return this.params;
            }

            public void setParams(LiquidityPoolConstantProductParameters value) {
                this.params = value;
            }

            public Int64 getReserveA() {
                return this.reserveA;
            }

            public void setReserveA(Int64 value) {
                this.reserveA = value;
            }

            public Int64 getReserveB() {
                return this.reserveB;
            }

            public void setReserveB(Int64 value) {
                this.reserveB = value;
            }

            public Int64 getTotalPoolShares() {
                return this.totalPoolShares;
            }

            public void setTotalPoolShares(Int64 value) {
                this.totalPoolShares = value;
            }

            public Int64 getPoolSharesTrustLineCount() {
                return this.poolSharesTrustLineCount;
            }

            public void setPoolSharesTrustLineCount(Int64 value) {
                this.poolSharesTrustLineCount = value;
            }

            public static void encode(XdrDataOutputStream stream, LiquidityPoolEntryConstantProduct encodedLiquidityPoolEntryConstantProduct) throws IOException {
                LiquidityPoolConstantProductParameters.encode(stream, encodedLiquidityPoolEntryConstantProduct.params);
                Int64.encode(stream, encodedLiquidityPoolEntryConstantProduct.reserveA);
                Int64.encode(stream, encodedLiquidityPoolEntryConstantProduct.reserveB);
                Int64.encode(stream, encodedLiquidityPoolEntryConstantProduct.totalPoolShares);
                Int64.encode(stream, encodedLiquidityPoolEntryConstantProduct.poolSharesTrustLineCount);
            }

            @Override
            public void encode(XdrDataOutputStream stream) throws IOException {
                LiquidityPoolEntryConstantProduct.encode(stream, this);
            }

            public static LiquidityPoolEntryConstantProduct decode(XdrDataInputStream stream) throws IOException {
                LiquidityPoolEntryConstantProduct decodedLiquidityPoolEntryConstantProduct = new LiquidityPoolEntryConstantProduct();
                decodedLiquidityPoolEntryConstantProduct.params = LiquidityPoolConstantProductParameters.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.reserveA = Int64.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.reserveB = Int64.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.totalPoolShares = Int64.decode(stream);
                decodedLiquidityPoolEntryConstantProduct.poolSharesTrustLineCount = Int64.decode(stream);
                return decodedLiquidityPoolEntryConstantProduct;
            }

            public int hashCode() {
                return Objects.hash(this.params, this.reserveA, this.reserveB, this.totalPoolShares, this.poolSharesTrustLineCount);
            }

            public boolean equals(Object object) {
                if (!(object instanceof LiquidityPoolEntryConstantProduct)) {
                    return false;
                }
                LiquidityPoolEntryConstantProduct other = (LiquidityPoolEntryConstantProduct)object;
                return Objects.equals(this.params, other.params) && Objects.equals(this.reserveA, other.reserveA) && Objects.equals(this.reserveB, other.reserveB) && Objects.equals(this.totalPoolShares, other.totalPoolShares) && Objects.equals(this.poolSharesTrustLineCount, other.poolSharesTrustLineCount);
            }

            @Override
            public String toXdrBase64() throws IOException {
                return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
            }

            @Override
            public byte[] toXdrByteArray() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
                this.encode(xdrDataOutputStream);
                return byteArrayOutputStream.toByteArray();
            }

            public static LiquidityPoolEntryConstantProduct fromXdrBase64(String xdr) throws IOException {
                byte[] bytes = Base64Factory.getInstance().decode(xdr);
                return LiquidityPoolEntryConstantProduct.fromXdrByteArray(bytes);
            }

            public static LiquidityPoolEntryConstantProduct fromXdrByteArray(byte[] xdr) throws IOException {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
                XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
                return LiquidityPoolEntryConstantProduct.decode(xdrDataInputStream);
            }

            public static final class Builder {
                private LiquidityPoolConstantProductParameters params;
                private Int64 reserveA;
                private Int64 reserveB;
                private Int64 totalPoolShares;
                private Int64 poolSharesTrustLineCount;

                public Builder params(LiquidityPoolConstantProductParameters params) {
                    this.params = params;
                    return this;
                }

                public Builder reserveA(Int64 reserveA) {
                    this.reserveA = reserveA;
                    return this;
                }

                public Builder reserveB(Int64 reserveB) {
                    this.reserveB = reserveB;
                    return this;
                }

                public Builder totalPoolShares(Int64 totalPoolShares) {
                    this.totalPoolShares = totalPoolShares;
                    return this;
                }

                public Builder poolSharesTrustLineCount(Int64 poolSharesTrustLineCount) {
                    this.poolSharesTrustLineCount = poolSharesTrustLineCount;
                    return this;
                }

                public LiquidityPoolEntryConstantProduct build() {
                    LiquidityPoolEntryConstantProduct val = new LiquidityPoolEntryConstantProduct();
                    val.setParams(this.params);
                    val.setReserveA(this.reserveA);
                    val.setReserveB(this.reserveB);
                    val.setTotalPoolShares(this.totalPoolShares);
                    val.setPoolSharesTrustLineCount(this.poolSharesTrustLineCount);
                    return val;
                }
            }
        }

        public static final class Builder {
            private LiquidityPoolType discriminant;
            private LiquidityPoolEntryConstantProduct constantProduct;

            public Builder discriminant(LiquidityPoolType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder constantProduct(LiquidityPoolEntryConstantProduct constantProduct) {
                this.constantProduct = constantProduct;
                return this;
            }

            public LiquidityPoolEntryBody build() {
                LiquidityPoolEntryBody val = new LiquidityPoolEntryBody();
                val.setDiscriminant(this.discriminant);
                val.setConstantProduct(this.constantProduct);
                return val;
            }
        }
    }

    public static final class Builder {
        private PoolID liquidityPoolID;
        private LiquidityPoolEntryBody body;

        public Builder liquidityPoolID(PoolID liquidityPoolID) {
            this.liquidityPoolID = liquidityPoolID;
            return this;
        }

        public Builder body(LiquidityPoolEntryBody body) {
            this.body = body;
            return this;
        }

        public LiquidityPoolEntry build() {
            LiquidityPoolEntry val = new LiquidityPoolEntry();
            val.setLiquidityPoolID(this.liquidityPoolID);
            val.setBody(this.body);
            return val;
        }
    }
}

