/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ManageBuyOfferResultCode;
import org.stellar.sdk.xdr.ManageOfferSuccessResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ManageBuyOfferResult
implements XdrElement {
    ManageBuyOfferResultCode code;
    private ManageOfferSuccessResult success;

    public ManageBuyOfferResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(ManageBuyOfferResultCode value) {
        this.code = value;
    }

    public ManageOfferSuccessResult getSuccess() {
        return this.success;
    }

    public void setSuccess(ManageOfferSuccessResult value) {
        this.success = value;
    }

    public static void encode(XdrDataOutputStream stream, ManageBuyOfferResult encodedManageBuyOfferResult) throws IOException {
        stream.writeInt(encodedManageBuyOfferResult.getDiscriminant().getValue());
        switch (encodedManageBuyOfferResult.getDiscriminant()) {
            case MANAGE_BUY_OFFER_SUCCESS: {
                ManageOfferSuccessResult.encode(stream, encodedManageBuyOfferResult.success);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ManageBuyOfferResult.encode(stream, this);
    }

    public static ManageBuyOfferResult decode(XdrDataInputStream stream) throws IOException {
        ManageBuyOfferResult decodedManageBuyOfferResult = new ManageBuyOfferResult();
        ManageBuyOfferResultCode discriminant = ManageBuyOfferResultCode.decode(stream);
        decodedManageBuyOfferResult.setDiscriminant(discriminant);
        switch (decodedManageBuyOfferResult.getDiscriminant()) {
            case MANAGE_BUY_OFFER_SUCCESS: {
                decodedManageBuyOfferResult.success = ManageOfferSuccessResult.decode(stream);
                break;
            }
        }
        return decodedManageBuyOfferResult;
    }

    public int hashCode() {
        return Objects.hash(this.success, this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ManageBuyOfferResult)) {
            return false;
        }
        ManageBuyOfferResult other = (ManageBuyOfferResult)object;
        return Objects.equals(this.success, other.success) && Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ManageBuyOfferResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ManageBuyOfferResult.fromXdrByteArray(bytes);
    }

    public static ManageBuyOfferResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ManageBuyOfferResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ManageBuyOfferResultCode discriminant;
        private ManageOfferSuccessResult success;

        public Builder discriminant(ManageBuyOfferResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder success(ManageOfferSuccessResult success) {
            this.success = success;
            return this;
        }

        public ManageBuyOfferResult build() {
            ManageBuyOfferResult val = new ManageBuyOfferResult();
            val.setDiscriminant(this.discriminant);
            val.setSuccess(this.success);
            return val;
        }
    }
}

